/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.cluster.IGlobalRecoveryManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.statement.DatasetDecl;
import org.apache.asterix.lang.common.statement.DataverseDropStatement;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.DropDatasetStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.metadata.dataset.hints.DatasetHints;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.utils.MetadataConstants;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLangTranslator {
    private static final Logger LOGGER = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateOperation(ICcApplicationContext appCtx, Dataverse defaultDataverse, Statement stmt) throws AlgebricksException {
        int maxWaitCycles;
        IClusterStateManager clusterStateManager = appCtx.getClusterStateManager();
        IGlobalRecoveryManager globalRecoveryManager = appCtx.getGlobalRecoveryManager();
        if (!clusterStateManager.getState().equals((Object)IClusterManagementWork.ClusterState.ACTIVE) || !globalRecoveryManager.isRecoveryCompleted()) {
            maxWaitCycles = appCtx.getExternalProperties().getMaxWaitClusterActive();
            try {
                clusterStateManager.waitForState(IClusterManagementWork.ClusterState.ACTIVE, (long)maxWaitCycles, TimeUnit.SECONDS);
            }
            catch (HyracksDataException e) {
                throw new AsterixException((Throwable)e);
            }
            catch (InterruptedException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Thread interrupted while waiting for cluster to be " + IClusterManagementWork.ClusterState.ACTIVE);
                }
                Thread.currentThread().interrupt();
            }
            IClusterStateManager e = clusterStateManager;
            synchronized (e) {
                if (!clusterStateManager.getState().equals((Object)IClusterManagementWork.ClusterState.ACTIVE)) {
                    ClusterPartition[] configuredPartitions = clusterStateManager.getClusterPartitons();
                    HashSet<String> inactiveNodes = new HashSet<String>();
                    for (ClusterPartition cp : configuredPartitions) {
                        if (cp.isActive()) continue;
                        inactiveNodes.add(cp.getNodeId());
                    }
                    throw AsterixException.create((int)4006, (Serializable[])new Serializable[]{Arrays.toString(inactiveNodes.toArray())});
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Cluster is now " + IClusterManagementWork.ClusterState.ACTIVE);
                }
            }
        }
        if (!globalRecoveryManager.isRecoveryCompleted()) {
            maxWaitCycles = appCtx.getExternalProperties().getMaxWaitClusterActive();
            try {
                for (int waitCycleCount = 0; !globalRecoveryManager.isRecoveryCompleted() && waitCycleCount < maxWaitCycles; ++waitCycleCount) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Thread interrupted while waiting for cluster to complete global recovery ");
                }
                Thread.currentThread().interrupt();
            }
            if (!globalRecoveryManager.isRecoveryCompleted()) {
                throw new AsterixException("Cluster Global recovery is not yet complete and the system is in " + IClusterManagementWork.ClusterState.ACTIVE + " state");
            }
        }
        boolean invalidOperation = false;
        String message = null;
        DataverseName dataverseName = defaultDataverse != null ? defaultDataverse.getDataverseName() : null;
        switch (stmt.getKind()) {
            case INSERT: {
                InsertStatement insertStmt = (InsertStatement)stmt;
                if (insertStmt.getDataverseName() != null) {
                    dataverseName = insertStmt.getDataverseName();
                }
                if (!(invalidOperation = MetadataConstants.METADATA_DATAVERSE_NAME.equals((Object)dataverseName))) break;
                message = "Insert operation is not permitted in dataverse " + MetadataConstants.METADATA_DATAVERSE_NAME;
                break;
            }
            case DELETE: {
                DeleteStatement deleteStmt = (DeleteStatement)stmt;
                if (deleteStmt.getDataverseName() != null) {
                    dataverseName = deleteStmt.getDataverseName();
                }
                if (!(invalidOperation = MetadataConstants.METADATA_DATAVERSE_NAME.equals((Object)dataverseName))) break;
                message = "Delete operation is not permitted in dataverse " + MetadataConstants.METADATA_DATAVERSE_NAME;
                break;
            }
            case DATAVERSE_DROP: {
                DataverseDropStatement dvDropStmt = (DataverseDropStatement)stmt;
                dataverseName = dvDropStmt.getDataverseName();
                invalidOperation = MetadataConstants.METADATA_DATAVERSE_NAME.equals((Object)dataverseName);
                if (!invalidOperation) break;
                message = "Cannot drop dataverse:" + dataverseName;
                break;
            }
            case DATASET_DROP: {
                DropDatasetStatement dropStmt = (DropDatasetStatement)stmt;
                if (dropStmt.getDataverseName() != null) {
                    dataverseName = dropStmt.getDataverseName();
                }
                if (!(invalidOperation = MetadataConstants.METADATA_DATAVERSE_NAME.equals((Object)dataverseName))) break;
                message = "Cannot drop a dataset belonging to the dataverse:" + MetadataConstants.METADATA_DATAVERSE_NAME;
                break;
            }
            case DATASET_DECL: {
                DatasetDecl datasetStmt = (DatasetDecl)stmt;
                Map hints = datasetStmt.getHints();
                if (hints == null || hints.isEmpty()) break;
                StringBuilder errorMsgBuffer = new StringBuilder();
                for (Map.Entry hint : hints.entrySet()) {
                    Pair validationResult = DatasetHints.validate((ICcApplicationContext)appCtx, (String)((String)hint.getKey()), (String)((String)hint.getValue()));
                    if (((Boolean)validationResult.first).booleanValue()) continue;
                    errorMsgBuffer.append("Dataset: ").append(datasetStmt.getName().getValue()).append(" error in processing hint: ").append((String)hint.getKey()).append(" ").append((String)validationResult.second);
                    errorMsgBuffer.append(" \n");
                }
                boolean bl = invalidOperation = errorMsgBuffer.length() > 0;
                if (!invalidOperation) break;
                message = errorMsgBuffer.toString();
                break;
            }
        }
        if (invalidOperation) {
            throw new AsterixException("Invalid operation - " + message);
        }
    }
}

