/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.job.profiling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.com.job.profiling.counters.Counter;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.job.profiling.counters.ICounter;

public class OperatorStats
implements IOperatorStats {
    private static final long serialVersionUID = 6401830963367567167L;
    public final String operatorName;
    public final ICounter tupleCounter;
    public final ICounter timeCounter;
    public final ICounter diskIoCounter;

    public OperatorStats(String operatorName) {
        if (operatorName == null || operatorName.isEmpty()) {
            throw new IllegalArgumentException("operatorName must not be null or empty");
        }
        this.operatorName = operatorName;
        this.tupleCounter = new Counter("tupleCounter");
        this.timeCounter = new Counter("timeCounter");
        this.diskIoCounter = new Counter("diskIoCounter");
    }

    public static IOperatorStats create(DataInput input) throws IOException {
        String name = input.readUTF();
        OperatorStats operatorStats = new OperatorStats(name);
        operatorStats.readFields(input);
        return operatorStats;
    }

    @Override
    public String getName() {
        return this.operatorName;
    }

    @Override
    public ICounter getTupleCounter() {
        return this.tupleCounter;
    }

    @Override
    public ICounter getTimeCounter() {
        return this.timeCounter;
    }

    @Override
    public ICounter getDiskIoCounter() {
        return this.diskIoCounter;
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        output.writeUTF(this.operatorName);
        output.writeLong(this.tupleCounter.get());
        output.writeLong(this.timeCounter.get());
        output.writeLong(this.diskIoCounter.get());
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.tupleCounter.set(input.readLong());
        this.timeCounter.set(input.readLong());
        this.diskIoCounter.set(input.readLong());
    }

    public String toString() {
        return "{ \"operatorName\": \"" + this.operatorName + "\", \"" + this.tupleCounter.getName() + "\": " + this.tupleCounter.get() + ", \"" + this.timeCounter.getName() + "\": " + this.timeCounter.get() + " }";
    }
}

