/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.IMutationDataSource;
import org.apache.asterix.optimizer.rules.CompositeExpressionReferenceTransform;
import org.apache.asterix.optimizer.rules.ILogicalExpressionReferenceTransformWithCondition;
import org.apache.asterix.optimizer.rules.LogicalExpressionReferenceTransform;
import org.apache.asterix.optimizer.rules.MetaKeyExpressionReferenceTransform;
import org.apache.asterix.optimizer.rules.MetaKeyToFieldAccessTransform;
import org.apache.asterix.optimizer.rules.NoOpExpressionReferenceTransform;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class MetaFunctionToMetaVariableRule
implements IAlgebraicRewriteRule {
    private boolean hasApplied = false;
    private boolean rewritten = false;

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (this.hasApplied) {
            return false;
        }
        this.hasApplied = true;
        this.visit(opRef);
        return this.rewritten;
    }

    private ILogicalExpressionReferenceTransformWithCondition visit(Mutable<ILogicalOperator> opRef) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getInputs().isEmpty()) {
            return NoOpExpressionReferenceTransform.INSTANCE;
        }
        if (op.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
            DataSourceScanOperator scanOp = (DataSourceScanOperator)op;
            ILogicalExpressionReferenceTransformWithCondition inputTransformer = this.visit((Mutable<ILogicalOperator>)((Mutable)op.getInputs().get(0)));
            DataSource dataSource = (DataSource)scanOp.getDataSource();
            ArrayList<ILogicalExpressionReferenceTransformWithCondition> transformers = null;
            List allVars = scanOp.getVariables();
            LogicalVariable dataVar = dataSource.getDataRecordVariable(allVars);
            LogicalVariable metaVar = dataSource.getMetaVariable(allVars);
            LogicalExpressionReferenceTransform currentTransformer = null;
            if (dataSource.getDatasourceType() != 1 && dataSource.getDatasourceType() != 0 && dataSource.getDatasourceType() != 3 && dataSource.getDatasourceType() != 4) {
                IMutationDataSource mds = (IMutationDataSource)dataSource;
                if (mds.isChange()) {
                    transformers = new ArrayList();
                    transformers.add(new MetaKeyExpressionReferenceTransform(mds.getPkVars(allVars), mds.getKeyAccessExpression()));
                } else if (metaVar != null) {
                    transformers = new ArrayList();
                    transformers.add(new MetaKeyToFieldAccessTransform(metaVar));
                }
            }
            if (!dataSource.hasMeta() && transformers == null) {
                return inputTransformer;
            }
            if (metaVar != null) {
                currentTransformer = new LogicalExpressionReferenceTransform(dataVar, metaVar);
            }
            if (inputTransformer.equals(NoOpExpressionReferenceTransform.INSTANCE) && transformers == null) {
                return currentTransformer;
            }
            if (inputTransformer.equals(NoOpExpressionReferenceTransform.INSTANCE) && currentTransformer == null) {
                return (ILogicalExpressionReferenceTransformWithCondition)transformers.get(0);
            }
            if (transformers == null) {
                transformers = new ArrayList<ILogicalExpressionReferenceTransformWithCondition>();
            }
            if (!inputTransformer.equals(NoOpExpressionReferenceTransform.INSTANCE)) {
                inputTransformer.setVariableRequired();
                currentTransformer.setVariableRequired();
                transformers.add(inputTransformer);
            }
            transformers.add(currentTransformer);
            return new CompositeExpressionReferenceTransform(transformers);
        }
        ArrayList<ILogicalExpressionReferenceTransformWithCondition> transformers = new ArrayList<ILogicalExpressionReferenceTransformWithCondition>();
        for (Object childRef : op.getInputs()) {
            ILogicalExpressionReferenceTransformWithCondition transformer = this.visit((Mutable<ILogicalOperator>)childRef);
            if (transformer.equals(NoOpExpressionReferenceTransform.INSTANCE)) continue;
            transformers.add(transformer);
        }
        ILogicalExpressionReferenceTransformWithCondition currentTransformer = null;
        if (transformers.isEmpty()) {
            currentTransformer = NoOpExpressionReferenceTransform.INSTANCE;
        } else if (transformers.size() == 1) {
            currentTransformer = (ILogicalExpressionReferenceTransformWithCondition)transformers.get(0);
        } else {
            for (ILogicalExpressionReferenceTransformWithCondition transformer : transformers) {
                transformer.setVariableRequired();
            }
            currentTransformer = new CompositeExpressionReferenceTransform(transformers);
        }
        if (((AbstractLogicalOperator)op).hasNestedPlans()) {
            AbstractOperatorWithNestedPlans opWithNestedPlans = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan nestedPlan : opWithNestedPlans.getNestedPlans()) {
                for (Mutable root : nestedPlan.getRoots()) {
                    this.visit((Mutable<ILogicalOperator>)root);
                }
            }
        }
        this.rewritten |= op.acceptExpressionTransform((ILogicalExpressionReferenceTransform)currentTransformer);
        return currentTransformer;
    }
}

