/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.transactions.ITxnIdFactory;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.runtime.message.TxnIdBlockRequest;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class CachingTxnIdFactory
implements ITxnIdFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    private final INcApplicationContext appCtx;
    private volatile Block block = new Block(0L, 0L);

    public CachingTxnIdFactory(INcApplicationContext appCtx) {
        this.appCtx = appCtx;
    }

    public TxnId create() throws AlgebricksException {
        while (true) {
            try {
                return new TxnId(this.block.nextId());
            }
            catch (BlockExhaustedException ex) {
                TxnIdBlockRequest.Block newBlock;
                LOGGER.info("block exhausted; obtaining new block from supplier");
                try {
                    newBlock = TxnIdBlockRequest.send((INcApplicationContext)this.appCtx);
                }
                catch (HyracksDataException e) {
                    throw new AlgebricksException((Throwable)e);
                }
                this.block = new Block(newBlock.getStartingId(), newBlock.getBlockSize());
                continue;
            }
            break;
        }
    }

    public void ensureMinimumId(long id) {
        throw new UnsupportedOperationException();
    }

    public long getIdBlock(int blockSize) {
        throw new UnsupportedOperationException();
    }

    public long getMaxTxnId() {
        return this.block.endExclusive - 1L;
    }

    private static class BlockExhaustedException
    extends Exception {
        private static final long serialVersionUID = 8967868415735213490L;

        private BlockExhaustedException() {
        }
    }

    static class Block {
        private static final BlockExhaustedException BLOCK_EXHAUSTED_EXCEPTION = new BlockExhaustedException();
        private final AtomicLong id;
        private final long start;
        private final long endExclusive;

        private Block(long start, long blockSize) {
            this.id = new AtomicLong(start);
            this.start = start;
            this.endExclusive = start + blockSize;
        }

        private long nextId() throws BlockExhaustedException {
            long nextId = this.id.getAndIncrement();
            if (nextId >= this.endExclusive && (this.endExclusive >= this.start || nextId < this.start)) {
                throw BLOCK_EXHAUSTED_EXCEPTION;
            }
            return nextId;
        }
    }
}

