/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.micrometer.core.instrument.Gauge;
import java.net.SocketAddress;
import reactor.netty.Metrics;
import reactor.netty.resources.ConnectionPoolMetrics;
import reactor.netty.resources.ConnectionProvider;

final class MicrometerPooledConnectionProviderMeterRegistrar
implements ConnectionProvider.MeterRegistrar {
    static final MicrometerPooledConnectionProviderMeterRegistrar INSTANCE = new MicrometerPooledConnectionProviderMeterRegistrar();

    private MicrometerPooledConnectionProviderMeterRegistrar() {
    }

    @Override
    public void registerMetrics(String poolName, String id, SocketAddress remoteAddress, ConnectionPoolMetrics metrics) {
        String addressAsString = Metrics.formatSocketAddress(remoteAddress);
        String[] tags = new String[]{"id", id, "remote.address", addressAsString, "name", poolName};
        Gauge.builder((String)"reactor.netty.connection.provider.total.connections", (Object)metrics, ConnectionPoolMetrics::allocatedSize).description("The number of all connections, active or idle.").tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"reactor.netty.connection.provider.active.connections", (Object)metrics, ConnectionPoolMetrics::acquiredSize).description("The number of the connections that have been successfully acquired and are in active use").tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"reactor.netty.connection.provider.idle.connections", (Object)metrics, ConnectionPoolMetrics::idleSize).description("The number of the idle connections").tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"reactor.netty.connection.provider.pending.connections", (Object)metrics, ConnectionPoolMetrics::pendingAcquireSize).description("The number of the request, that are pending acquire a connection").tags(tags).register(Metrics.REGISTRY);
    }
}

