/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class ByteArrayFrontCodedList
extends AbstractObjectList<byte[]>
implements Serializable,
Cloneable,
RandomAccess {
    private static final long serialVersionUID = 1L;
    protected final int n;
    protected final int ratio;
    protected final byte[][] array;
    protected transient long[] p;

    public ByteArrayFrontCodedList(Iterator<byte[]> arrays, int ratio) {
        if (ratio < 1) {
            throw new IllegalArgumentException("Illegal ratio (" + ratio + ")");
        }
        byte[][] array = ByteBigArrays.EMPTY_BIG_ARRAY;
        long[] p = LongArrays.EMPTY_ARRAY;
        byte[][] a = new byte[2][];
        long curSize = 0L;
        int n = 0;
        int b = 0;
        while (arrays.hasNext()) {
            a[b] = arrays.next();
            int length = a[b].length;
            if (n % ratio == 0) {
                p = LongArrays.grow((long[])p, (int)(n / ratio + 1));
                p[n / ratio] = curSize;
                array = BigArrays.grow((byte[][])array, (long)(curSize + (long)ByteArrayFrontCodedList.count(length) + (long)length), (long)curSize);
                curSize += (long)ByteArrayFrontCodedList.writeInt(array, length, curSize);
                BigArrays.copyToBig((byte[])a[b], (int)0, (byte[][])array, (long)curSize, (long)length);
                curSize += (long)length;
            } else {
                int common;
                int minLength = a[1 - b].length;
                if (length < minLength) {
                    minLength = length;
                }
                for (common = 0; common < minLength && a[0][common] == a[1][common]; ++common) {
                }
                array = BigArrays.grow((byte[][])array, (long)(curSize + (long)ByteArrayFrontCodedList.count(length -= common) + (long)ByteArrayFrontCodedList.count(common) + (long)length), (long)curSize);
                curSize += (long)ByteArrayFrontCodedList.writeInt(array, length, curSize);
                curSize += (long)ByteArrayFrontCodedList.writeInt(array, common, curSize);
                BigArrays.copyToBig((byte[])a[b], (int)common, (byte[][])array, (long)curSize, (long)length);
                curSize += (long)length;
            }
            b = 1 - b;
            ++n;
        }
        this.n = n;
        this.ratio = ratio;
        this.array = BigArrays.trim((byte[][])array, (long)curSize);
        this.p = LongArrays.trim((long[])p, (int)((n + ratio - 1) / ratio));
    }

    public ByteArrayFrontCodedList(Collection<byte[]> c, int ratio) {
        this(c.iterator(), ratio);
    }

    static int readInt(byte[][] a, long pos) {
        byte b0 = BigArrays.get((byte[][])a, (long)pos);
        if (b0 >= 0) {
            return b0;
        }
        byte b1 = BigArrays.get((byte[][])a, (long)(pos + 1L));
        if (b1 >= 0) {
            return -b0 - 1 << 7 | b1;
        }
        byte b2 = BigArrays.get((byte[][])a, (long)(pos + 2L));
        if (b2 >= 0) {
            return -b0 - 1 << 14 | -b1 - 1 << 7 | b2;
        }
        byte b3 = BigArrays.get((byte[][])a, (long)(pos + 3L));
        if (b3 >= 0) {
            return -b0 - 1 << 21 | -b1 - 1 << 14 | -b2 - 1 << 7 | b3;
        }
        return -b0 - 1 << 28 | -b1 - 1 << 21 | -b2 - 1 << 14 | -b3 - 1 << 7 | BigArrays.get((byte[][])a, (long)(pos + 4L));
    }

    static int count(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 16384) {
            return 2;
        }
        if (length < 0x200000) {
            return 3;
        }
        if (length < 0x10000000) {
            return 4;
        }
        return 5;
    }

    static int writeInt(byte[][] a, int length, long pos) {
        int count = ByteArrayFrontCodedList.count(length);
        BigArrays.set((byte[][])a, (long)(pos + (long)count - 1L), (byte)((byte)(length & 0x7F)));
        if (count != 1) {
            int i = count - 1;
            while (i-- != 0) {
                BigArrays.set((byte[][])a, (long)(pos + (long)i), (byte)((byte)(-((length >>>= 7) & 0x7F) - 1)));
            }
        }
        return count;
    }

    public int ratio() {
        return this.ratio;
    }

    private int length(int index) {
        byte[][] array = this.array;
        int delta = index % this.ratio;
        long pos = this.p[index / this.ratio];
        int length = ByteArrayFrontCodedList.readInt(array, pos);
        if (delta == 0) {
            return length;
        }
        pos += (long)(ByteArrayFrontCodedList.count(length) + length);
        length = ByteArrayFrontCodedList.readInt(array, pos);
        int common = ByteArrayFrontCodedList.readInt(array, pos + (long)ByteArrayFrontCodedList.count(length));
        for (int i = 0; i < delta - 1; ++i) {
            length = ByteArrayFrontCodedList.readInt(array, pos += (long)(ByteArrayFrontCodedList.count(length) + ByteArrayFrontCodedList.count(common) + length));
            common = ByteArrayFrontCodedList.readInt(array, pos + (long)ByteArrayFrontCodedList.count(length));
        }
        return length + common;
    }

    public int arrayLength(int index) {
        this.ensureRestrictedIndex(index);
        return this.length(index);
    }

    private int extract(int index, byte[] a, int offset, int length) {
        long startPos;
        int delta = index % this.ratio;
        long pos = startPos = this.p[index / this.ratio];
        int arrayLength = ByteArrayFrontCodedList.readInt(this.array, pos);
        int currLen = 0;
        if (delta == 0) {
            pos = this.p[index / this.ratio] + (long)ByteArrayFrontCodedList.count(arrayLength);
            BigArrays.copyFromBig((byte[][])this.array, (long)pos, (byte[])a, (int)offset, (int)Math.min(length, arrayLength));
            return arrayLength;
        }
        int common = 0;
        for (int i = 0; i < delta; ++i) {
            long prevArrayPos = pos + (long)ByteArrayFrontCodedList.count(arrayLength) + (long)(i != 0 ? ByteArrayFrontCodedList.count(common) : 0);
            common = ByteArrayFrontCodedList.readInt(this.array, (pos = prevArrayPos + (long)arrayLength) + (long)ByteArrayFrontCodedList.count(arrayLength = ByteArrayFrontCodedList.readInt(this.array, pos)));
            int actualCommon = Math.min(common, length);
            if (actualCommon <= currLen) {
                currLen = actualCommon;
                continue;
            }
            BigArrays.copyFromBig((byte[][])this.array, (long)prevArrayPos, (byte[])a, (int)(currLen + offset), (int)(actualCommon - currLen));
            currLen = actualCommon;
        }
        if (currLen < length) {
            BigArrays.copyFromBig((byte[][])this.array, (long)(pos + (long)ByteArrayFrontCodedList.count(arrayLength) + (long)ByteArrayFrontCodedList.count(common)), (byte[])a, (int)(currLen + offset), (int)Math.min(arrayLength, length - currLen));
        }
        return arrayLength + common;
    }

    public byte[] get(int index) {
        return this.getArray(index);
    }

    public byte[] getArray(int index) {
        this.ensureRestrictedIndex(index);
        int length = this.length(index);
        byte[] a = new byte[length];
        this.extract(index, a, 0, length);
        return a;
    }

    public int get(int index, byte[] a, int offset, int length) {
        this.ensureRestrictedIndex(index);
        ByteArrays.ensureOffsetLength((byte[])a, (int)offset, (int)length);
        int arrayLength = this.extract(index, a, offset, length);
        if (length >= arrayLength) {
            return arrayLength;
        }
        return length - arrayLength;
    }

    public int get(int index, byte[] a) {
        return this.get(index, a, 0, a.length);
    }

    public int size() {
        return this.n;
    }

    public ObjectListIterator<byte[]> listIterator(final int start) {
        this.ensureIndex(start);
        return new ObjectListIterator<byte[]>(){
            byte[] s = ByteArrays.EMPTY_ARRAY;
            int i = 0;
            long pos = 0L;
            boolean inSync;
            {
                if (start != 0) {
                    if (start == ByteArrayFrontCodedList.this.n) {
                        this.i = start;
                    } else {
                        this.pos = ByteArrayFrontCodedList.this.p[start / ByteArrayFrontCodedList.this.ratio];
                        int j = start % ByteArrayFrontCodedList.this.ratio;
                        this.i = start - j;
                        while (j-- != 0) {
                            this.next();
                        }
                    }
                }
            }

            public boolean hasNext() {
                return this.i < ByteArrayFrontCodedList.this.n;
            }

            public boolean hasPrevious() {
                return this.i > 0;
            }

            public int previousIndex() {
                return this.i - 1;
            }

            public int nextIndex() {
                return this.i;
            }

            public byte[] next() {
                int length;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.i % ByteArrayFrontCodedList.this.ratio == 0) {
                    this.pos = ByteArrayFrontCodedList.this.p[this.i / ByteArrayFrontCodedList.this.ratio];
                    length = ByteArrayFrontCodedList.readInt(ByteArrayFrontCodedList.this.array, this.pos);
                    this.s = ByteArrays.ensureCapacity((byte[])this.s, (int)length, (int)0);
                    BigArrays.copyFromBig((byte[][])ByteArrayFrontCodedList.this.array, (long)(this.pos + (long)ByteArrayFrontCodedList.count(length)), (byte[])this.s, (int)0, (int)length);
                    this.pos += (long)(length + ByteArrayFrontCodedList.count(length));
                    this.inSync = true;
                } else if (this.inSync) {
                    length = ByteArrayFrontCodedList.readInt(ByteArrayFrontCodedList.this.array, this.pos);
                    int common = ByteArrayFrontCodedList.readInt(ByteArrayFrontCodedList.this.array, this.pos + (long)ByteArrayFrontCodedList.count(length));
                    this.s = ByteArrays.ensureCapacity((byte[])this.s, (int)(length + common), (int)common);
                    BigArrays.copyFromBig((byte[][])ByteArrayFrontCodedList.this.array, (long)(this.pos + (long)ByteArrayFrontCodedList.count(length) + (long)ByteArrayFrontCodedList.count(common)), (byte[])this.s, (int)common, (int)length);
                    this.pos += (long)(ByteArrayFrontCodedList.count(length) + ByteArrayFrontCodedList.count(common) + length);
                    length += common;
                } else {
                    length = ByteArrayFrontCodedList.this.length(this.i);
                    this.s = ByteArrays.ensureCapacity((byte[])this.s, (int)length, (int)0);
                    ByteArrayFrontCodedList.this.extract(this.i, this.s, 0, length);
                }
                ++this.i;
                return ByteArrays.copy((byte[])this.s, (int)0, (int)length);
            }

            public byte[] previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.inSync = false;
                return ByteArrayFrontCodedList.this.getArray(--this.i);
            }
        };
    }

    public ByteArrayFrontCodedList clone() {
        return this;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[");
        for (int i = 0; i < this.n; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(ByteArrayList.wrap(this.getArray(i)).toString());
        }
        s.append("]");
        return s.toString();
    }

    protected long[] rebuildPointerArray() {
        long[] p = new long[(this.n + this.ratio - 1) / this.ratio];
        byte[][] a = this.array;
        long pos = 0L;
        int j = 0;
        int skip = this.ratio - 1;
        for (int i = 0; i < this.n; ++i) {
            int length = ByteArrayFrontCodedList.readInt(a, pos);
            int count = ByteArrayFrontCodedList.count(length);
            if (++skip == this.ratio) {
                skip = 0;
                p[j++] = pos;
                pos += (long)(count + length);
                continue;
            }
            pos += (long)(count + ByteArrayFrontCodedList.count(ByteArrayFrontCodedList.readInt(a, pos + (long)count)) + length);
        }
        return p;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.p = this.rebuildPointerArray();
    }
}

