/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.std;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.algebricks.data.IUnnestingPositionWriter;
import org.apache.hyracks.algebricks.data.IUnnestingPositionWriterFactory;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.EvaluatorContext;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class UnnestRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final int outCol;
    private final IUnnestingEvaluatorFactory unnestingFactory;
    private final boolean unnestColIsProjected;
    private final IUnnestingPositionWriterFactory positionWriterFactory;
    private final boolean leftOuter;
    private final IMissingWriterFactory missingWriterFactory;
    private int outColPos;

    public UnnestRuntimeFactory(int outCol, IUnnestingEvaluatorFactory unnestingFactory, int[] projectionList, boolean leftOuter, IMissingWriterFactory missingWriterFactory) {
        this(outCol, unnestingFactory, projectionList, null, leftOuter, missingWriterFactory);
    }

    public UnnestRuntimeFactory(int outCol, IUnnestingEvaluatorFactory unnestingFactory, int[] projectionList, IUnnestingPositionWriterFactory positionWriterFactory, boolean leftOuter, IMissingWriterFactory missingWriterFactory) {
        super(projectionList);
        this.outCol = outCol;
        this.unnestingFactory = unnestingFactory;
        this.outColPos = -1;
        for (int f = 0; f < projectionList.length; ++f) {
            if (projectionList[f] != outCol) continue;
            this.outColPos = f;
        }
        this.unnestColIsProjected = this.outColPos >= 0;
        this.positionWriterFactory = positionWriterFactory;
        this.leftOuter = leftOuter;
        this.missingWriterFactory = missingWriterFactory;
    }

    public String toString() {
        return "unnest " + this.outCol + " <- " + this.unnestingFactory;
    }

    @Override
    public AbstractOneInputOneOutputOneFramePushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws HyracksDataException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(bos);
        if (this.missingWriterFactory != null) {
            IMissingWriter missingWriter = this.missingWriterFactory.createMissingWriter();
            missingWriter.writeMissing((DataOutput)output);
        }
        final byte[] missingBytes = bos.toByteArray();
        final int missingBytesLen = bos.size();
        final EvaluatorContext evalCtx = new EvaluatorContext(ctx);
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            private IPointable p = VoidPointable.FACTORY.createPointable();
            private ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(UnnestRuntimeFactory.access$000(UnnestRuntimeFactory.this).length);
            private IUnnestingEvaluator unnest;
            private final IUnnestingPositionWriter positionWriter;
            {
                this.unnest = UnnestRuntimeFactory.this.unnestingFactory.createUnnestingEvaluator(evalCtx);
                this.positionWriter = UnnestRuntimeFactory.this.positionWriterFactory != null ? UnnestRuntimeFactory.this.positionWriterFactory.createUnnestingPositionWriter() : null;
            }

            @Override
            public void open() throws HyracksDataException {
                super.open();
                if (this.tRef == null) {
                    this.initAccessAppendRef(ctx);
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                for (int t = 0; t < nTuple; ++t) {
                    this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
                    try {
                        this.unnest.init((IFrameTupleReference)this.tRef);
                        this.unnesting(t);
                        continue;
                    }
                    catch (IOException ae) {
                        throw HyracksDataException.create((Throwable)ae);
                    }
                }
            }

            private void unnesting(int t) throws IOException {
                int positionIndex = 1;
                boolean emitted = false;
                while (this.unnest.step(this.p)) {
                    this.writeOutput(t, positionIndex++, false);
                    emitted = true;
                }
                if (UnnestRuntimeFactory.this.leftOuter && !emitted) {
                    this.writeOutput(t, -1, true);
                }
            }

            private void writeOutput(int t, int positionIndex, boolean missing) throws HyracksDataException, IOException {
                int f;
                if (!UnnestRuntimeFactory.this.unnestColIsProjected && this.positionWriter == null) {
                    this.appendProjectionToFrame(t, UnnestRuntimeFactory.this.projectionList);
                    this.appendToFrameFromTupleBuilder(this.tupleBuilder);
                    return;
                }
                this.tupleBuilder.reset();
                for (f = 0; f < UnnestRuntimeFactory.this.outColPos; ++f) {
                    this.tupleBuilder.addField((IFrameTupleAccessor)this.tAccess, t, f);
                }
                if (UnnestRuntimeFactory.this.unnestColIsProjected) {
                    if (missing) {
                        this.tupleBuilder.addField(missingBytes, 0, missingBytesLen);
                    } else {
                        this.tupleBuilder.addField(this.p.getByteArray(), this.p.getStartOffset(), this.p.getLength());
                    }
                }
                for (f = UnnestRuntimeFactory.this.unnestColIsProjected ? UnnestRuntimeFactory.this.outColPos + 1 : UnnestRuntimeFactory.this.outColPos; f < (this.positionWriter != null ? UnnestRuntimeFactory.this.projectionList.length - 1 : UnnestRuntimeFactory.this.projectionList.length); ++f) {
                    this.tupleBuilder.addField((IFrameTupleAccessor)this.tAccess, t, f);
                }
                if (this.positionWriter != null) {
                    if (missing) {
                        this.tupleBuilder.addField(missingBytes, 0, missingBytesLen);
                    } else {
                        this.positionWriter.write(this.tupleBuilder.getDataOutput(), (long)positionIndex);
                        this.tupleBuilder.addFieldEndOffset();
                    }
                }
                this.appendToFrameFromTupleBuilder(this.tupleBuilder);
            }

            public void flush() throws HyracksDataException {
                this.appender.flush(this.writer);
            }
        };
    }

    static /* synthetic */ int[] access$000(UnnestRuntimeFactory x0) {
        return x0.projectionList;
    }
}

