/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import org.apache.hyracks.dataflow.std.buffermanager.EnumFreeSlotPolicy;
import org.apache.hyracks.dataflow.std.buffermanager.FrameFreeSlotBiggestFirst;
import org.apache.hyracks.dataflow.std.buffermanager.FrameFreeSlotLastFit;
import org.apache.hyracks.dataflow.std.buffermanager.FrameFreeSlotSmallestFit;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameFreeSlotPolicy;

public class FrameFreeSlotPolicyFactory {
    public static IFrameFreeSlotPolicy createFreeSlotPolicy(EnumFreeSlotPolicy policy, int initialNumberFrames) {
        switch (policy) {
            case SMALLEST_FIT: {
                return new FrameFreeSlotSmallestFit();
            }
            case BIGGEST_FIT: {
                return new FrameFreeSlotBiggestFirst(initialNumberFrames);
            }
        }
        return new FrameFreeSlotLastFit(initialNumberFrames);
    }

    public static IFrameFreeSlotPolicy createFreeSlotPolicy(EnumFreeSlotPolicy policy) {
        switch (policy) {
            case SMALLEST_FIT: {
                return new FrameFreeSlotSmallestFit();
            }
            case BIGGEST_FIT: {
                return new FrameFreeSlotBiggestFirst();
            }
        }
        return new FrameFreeSlotLastFit();
    }
}

