/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.structures;

import org.apache.hyracks.dataflow.std.structures.AbstractHeap;
import org.apache.hyracks.dataflow.std.structures.IMinMaxHeap;
import org.apache.hyracks.dataflow.std.structures.IResetableComparable;
import org.apache.hyracks.dataflow.std.structures.IResetableComparableFactory;

public class MinMaxHeap
extends AbstractHeap
implements IMinMaxHeap<IResetableComparable> {
    public MinMaxHeap(IResetableComparableFactory factory, int capacity) {
        super(factory, capacity);
    }

    @Override
    protected void bubbleUp(int cid) {
        int pid = MinMaxHeap.getParentId(cid);
        if (this.isAtMinLevel(cid)) {
            if (pid != -1 && this.entries[pid].compareTo(this.entries[cid]) < 0) {
                this.swap(cid, pid);
                this.bubbleUpMax(pid);
            } else {
                this.bubbleUpMin(cid);
            }
        } else if (pid != -1 && this.entries[pid].compareTo(this.entries[cid]) > 0) {
            this.swap(cid, pid);
            this.bubbleUpMin(pid);
        } else {
            this.bubbleUpMax(cid);
        }
    }

    private void bubbleUpMin(int id) {
        int gp = this.getGrandParentId(id);
        if (gp != -1 && this.entries[gp].compareTo(this.entries[id]) > 0) {
            this.swap(gp, id);
            this.bubbleUpMin(gp);
        }
    }

    private void bubbleUpMax(int id) {
        int gp = this.getGrandParentId(id);
        if (gp != -1 && this.entries[gp].compareTo(this.entries[id]) < 0) {
            this.swap(gp, id);
            this.bubbleUpMax(gp);
        }
    }

    private boolean isAtMinLevel(int cid) {
        return this.getLevel(cid) % 2 == 0;
    }

    @Override
    public void getMin(IResetableComparable result) {
        result.reset(this.entries[0]);
        --this.numEntry;
        if (this.numEntry > 0) {
            this.entries[0].reset(this.entries[this.numEntry]);
            this.trickleDown(0);
        }
    }

    @Override
    public void getMax(IResetableComparable result) {
        int max = this.getMaxChild(0);
        if (max == -1) {
            this.getMin(result);
            return;
        }
        result.reset(this.entries[max]);
        --this.numEntry;
        if (this.numEntry > max) {
            this.entries[max].reset(this.entries[this.numEntry]);
            this.trickleDown(max);
        }
    }

    @Override
    protected void trickleDown(int id) {
        if (this.isAtMinLevel(id)) {
            this.trickleDownMin(id);
        } else {
            this.trickleDownMax(id);
        }
    }

    private void trickleDownMax(int id) {
        int maxId = this.getMaxOfDescendents(id);
        if (maxId == -1) {
            return;
        }
        if (this.isDirectChild(id, maxId)) {
            if (this.entries[id].compareTo(this.entries[maxId]) < 0) {
                this.swap(id, maxId);
            }
        } else if (this.entries[id].compareTo(this.entries[maxId]) < 0) {
            this.swap(id, maxId);
            int pid = MinMaxHeap.getParentId(maxId);
            if (this.entries[maxId].compareTo(this.entries[pid]) < 0) {
                this.swap(pid, maxId);
            }
            this.trickleDownMax(maxId);
        }
    }

    private void trickleDownMin(int id) {
        int minId = this.getMinOfDescendents(id);
        if (minId == -1) {
            return;
        }
        if (this.isDirectChild(id, minId)) {
            if (this.entries[id].compareTo(this.entries[minId]) > 0) {
                this.swap(id, minId);
            }
        } else if (this.entries[id].compareTo(this.entries[minId]) > 0) {
            this.swap(id, minId);
            int pid = MinMaxHeap.getParentId(minId);
            if (this.entries[minId].compareTo(this.entries[pid]) > 0) {
                this.swap(pid, minId);
            }
            this.trickleDownMin(minId);
        }
    }

    private int getMaxOfDescendents(int id) {
        int leftMax;
        int max = this.getMaxChild(id);
        if (max != -1 && (leftMax = this.getMaxChild(this.getLeftChild(id))) != -1) {
            max = this.entries[leftMax].compareTo(this.entries[max]) > 0 ? leftMax : max;
            int rightMax = this.getMaxChild(this.getRightChild(id));
            if (rightMax != -1) {
                max = this.entries[rightMax].compareTo(this.entries[max]) > 0 ? rightMax : max;
            }
        }
        return max;
    }

    private int getMinOfDescendents(int id) {
        int leftMin;
        int min = this.getMinChild(id);
        if (min != -1 && (leftMin = this.getMinChild(this.getLeftChild(id))) != -1) {
            min = this.entries[leftMin].compareTo(this.entries[min]) < 0 ? leftMin : min;
            int rightMin = this.getMinChild(this.getRightChild(id));
            if (rightMin != -1) {
                min = this.entries[rightMin].compareTo(this.entries[min]) < 0 ? rightMin : min;
            }
        }
        return min;
    }

    @Override
    public boolean isEmpty() {
        return this.numEntry == 0;
    }

    @Override
    public void peekMin(IResetableComparable result) {
        result.reset(this.entries[0]);
    }

    @Override
    public void peekMax(IResetableComparable result) {
        int maxChild = this.getMaxChild(0);
        if (maxChild == -1) {
            this.peekMin(result);
            return;
        }
        result.reset(this.entries[maxChild]);
    }

    @Override
    public void replaceMin(IResetableComparable newElement) {
        this.entries[0].reset(newElement);
        this.trickleDown(0);
    }

    @Override
    public void replaceMax(IResetableComparable newElement) {
        int maxChild = this.getMaxChild(0);
        if (maxChild == -1) {
            this.replaceMin(newElement);
            return;
        }
        this.entries[maxChild].reset(newElement);
        this.bubbleUp(maxChild);
        this.trickleDown(maxChild);
    }
}

