/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTreeCursorInitialState;
import org.apache.hyracks.storage.am.btree.impls.DiskBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleMode;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleNoExactMatchPolicy;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class DiskBTreePointSearchCursor
extends DiskBTreeRangeSearchCursor {
    private final boolean stateful;
    private boolean nextHasBeenCalled;
    private int lastPageId = -1;
    private int lastTupleIndex = 0;

    public DiskBTreePointSearchCursor(IBTreeLeafFrame frame, boolean exclusiveLatchNodes, boolean stateful) {
        super(frame, exclusiveLatchNodes);
        this.stateful = stateful;
    }

    public DiskBTreePointSearchCursor(IBTreeLeafFrame frame, boolean exclusiveLatchNodes) {
        this(frame, exclusiveLatchNodes, false);
    }

    @Override
    public boolean doHasNext() throws HyracksDataException {
        return this.tupleIndex >= 0 && !this.nextHasBeenCalled;
    }

    @Override
    public void doNext() throws HyracksDataException {
        this.nextHasBeenCalled = true;
    }

    @Override
    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        if (this.page != null) {
            this.resetBeforeOpen();
        }
        this.accessor = ((BTreeCursorInitialState)initialState).getAccessor();
        this.searchCb = initialState.getSearchOperationCallback();
        this.originalKeyCmp = initialState.getOriginalKeyComparator();
        this.pageId = ((BTreeCursorInitialState)initialState).getPageId();
        this.page = initialState.getPage();
        this.isPageDirty = false;
        this.frame.setPage(this.page);
        this.pred = (RangePredicate)searchPred;
        this.lowKeyCmp = this.pred.getLowKeyComparator();
        this.lowKey = this.pred.getLowKey();
        this.reusablePredicate.setLowKeyComparator(this.originalKeyCmp);
        this.lowKeyFtm = FindTupleMode.EXACT;
        this.lowKeyFtp = FindTupleNoExactMatchPolicy.NONE;
        this.nextHasBeenCalled = false;
        this.tupleIndex = this.getLowKeyIndex();
        if (this.stateful) {
            this.lastPageId = this.pageId;
            this.lastTupleIndex = this.tupleIndex >= 0 ? this.tupleIndex : -this.tupleIndex - 1;
        }
    }

    public int getLastPageId() {
        return this.lastPageId;
    }

    @Override
    protected int getLowKeyIndex() throws HyracksDataException {
        if (this.stateful) {
            return this.frame.findTupleIndex(this.lowKey, this.frameTuple, this.lowKeyCmp, this.lastTupleIndex);
        }
        return super.getLowKeyIndex();
    }

    public void clearSearchState() {
        this.lastPageId = -1;
        this.lastTupleIndex = 0;
    }
}

