/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.io;

import java.util.concurrent.BlockingQueue;
import org.apache.hyracks.api.util.InvokeUtil;
import org.apache.hyracks.control.nc.io.IoRequest;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IoRequestHandler
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final IoRequest POISON_PILL = new IoRequest(null, null, null);
    private final int num;
    private final BlockingQueue<IoRequest> queue;

    public IoRequestHandler(int num, BlockingQueue<IoRequest> queue) {
        this.num = num;
        this.queue = queue;
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.getClass().getSimpleName() + "-" + this.num);
        while (true) {
            IoRequest next;
            try {
                next = this.queue.take();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARN, "Ignoring interrupt. IO threads should never be interrupted.");
                continue;
            }
            if (next == POISON_PILL) {
                LOGGER.log(Level.INFO, "Exiting");
                InvokeUtil.doUninterruptibly(() -> this.queue.put(POISON_PILL));
                if (!Thread.interrupted()) break;
                LOGGER.log(Level.ERROR, "Ignoring interrupt. IO threads should never be interrupted.");
                break;
            }
            next.handle();
        }
    }
}

