/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.util.concurrent.TimeUnit;
import org.apache.asterix.common.config.AbstractProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.util.StorageUtil;

public class ReplicationProperties
extends AbstractProperties {
    public boolean isReplicationEnabled() {
        return this.accessor.getBoolean(Option.REPLICATION_ENABLED);
    }

    public ReplicationProperties(PropertiesAccessor accessor) {
        super(accessor);
    }

    public int getLogBufferPageSize() {
        return this.accessor.getInt(Option.REPLICATION_LOG_BUFFER_PAGESIZE);
    }

    public int getLogBufferNumOfPages() {
        return this.accessor.getInt(Option.REPLICATION_LOG_BUFFER_NUMPAGES);
    }

    public int getLogBatchSize() {
        return this.accessor.getInt(Option.REPLICATION_LOG_BATCHSIZE);
    }

    public String getReplicationAddress() {
        return this.accessor.getString((IOption)NCConfig.Option.REPLICATION_LISTEN_ADDRESS);
    }

    public int getReplicationPort() {
        return this.accessor.getInt((IOption)NCConfig.Option.REPLICATION_LISTEN_PORT);
    }

    public String getReplicationStrategy() {
        return this.accessor.getString(Option.REPLICATION_STRATEGY);
    }

    public long getReplicationTimeOut() {
        return this.accessor.getLong(Option.REPLICATION_TIMEOUT);
    }

    public int getReplicationFactor() {
        return this.accessor.getInt(Option.REPLICATION_FACTOR);
    }

    public static enum Option implements IOption
    {
        REPLICATION_LOG_BUFFER_PAGESIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)128, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE), "The size in bytes of each log buffer page"),
        REPLICATION_LOG_BUFFER_NUMPAGES(OptionTypes.POSITIVE_INTEGER, 8, "The number of log buffer pages"),
        REPLICATION_LOG_BATCHSIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)4, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE), "The size in bytes to replicate in each batch"),
        REPLICATION_TIMEOUT(OptionTypes.LONG, TimeUnit.SECONDS.toSeconds(30L), "The time in seconds to timeout waiting for master or replica to ack"),
        REPLICATION_ENABLED(OptionTypes.BOOLEAN, false, "Whether or not data replication is enabled"),
        REPLICATION_FACTOR(OptionTypes.NONNEGATIVE_INTEGER, 2, "Number of replicas (backups) to maintain per master replica"),
        REPLICATION_STRATEGY(OptionTypes.STRING, "none", "Replication strategy to choose");

        private final IOptionType type;
        private final Object defaultValue;
        private final String description;

        private Option(IOptionType type, Object defaultValue, String description) {
            this.type = type;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        public Section section() {
            return Section.COMMON;
        }

        public String description() {
            return this.description;
        }

        public IOptionType type() {
            return this.type;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }
    }
}

