/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables.printer;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.printer.AListPrinter;
import org.apache.asterix.om.pointables.printer.ARecordPrinter;
import org.apache.asterix.om.pointables.printer.IPrintVisitor;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class AbstractPrintVisitor
implements IPrintVisitor {
    private final Map<IVisitablePointable, ARecordPrinter> raccessorToPrinter = new HashMap<IVisitablePointable, ARecordPrinter>();
    private final Map<IVisitablePointable, AListPrinter> laccessorToPrinter = new HashMap<IVisitablePointable, AListPrinter>();

    @Override
    public Void visit(AListVisitablePointable accessor, Pair<PrintStream, ATypeTag> arg) throws HyracksDataException {
        AListPrinter printer = this.laccessorToPrinter.get(accessor);
        if (printer == null) {
            printer = this.createListPrinter(accessor);
            this.laccessorToPrinter.put(accessor, printer);
        }
        printer.printList(accessor, (PrintStream)arg.first, this);
        return null;
    }

    @Override
    public Void visit(ARecordVisitablePointable accessor, Pair<PrintStream, ATypeTag> arg) throws HyracksDataException {
        ARecordPrinter printer = this.raccessorToPrinter.get(accessor);
        if (printer == null) {
            printer = this.createRecordPrinter(accessor);
            this.raccessorToPrinter.put(accessor, printer);
        }
        printer.printRecord(accessor, (PrintStream)arg.first, this);
        return null;
    }

    @Override
    public Void visit(AFlatValuePointable accessor, Pair<PrintStream, ATypeTag> arg) throws HyracksDataException {
        PrintStream ps;
        int l;
        int s;
        ATypeTag typeTag = (ATypeTag)arg.second;
        byte[] b = accessor.getByteArray();
        if (!this.printFlatValue(typeTag, b, s = accessor.getStartOffset(), l = accessor.getLength(), ps = (PrintStream)arg.first)) {
            throw new HyracksDataException("No printer for type " + typeTag);
        }
        return null;
    }

    protected abstract AListPrinter createListPrinter(AListVisitablePointable var1) throws HyracksDataException;

    protected abstract ARecordPrinter createRecordPrinter(ARecordVisitablePointable var1) throws HyracksDataException;

    protected abstract boolean printFlatValue(ATypeTag var1, byte[] var2, int var3, int var4, PrintStream var5) throws HyracksDataException;
}

