/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.recovery;

import org.apache.asterix.common.transactions.ICheckpointManager;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CheckpointThread
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger();
    private long lsnThreshold;
    private long checkpointTermInSecs;
    private final ILogManager logManager;
    private final ICheckpointManager checkpointManager;
    private volatile boolean shouldRun = true;

    public CheckpointThread(ICheckpointManager checkpointManager, ILogManager logManager, long lsnThreshold, long checkpointTermInSecs) {
        this.checkpointManager = checkpointManager;
        this.logManager = logManager;
        this.lsnThreshold = lsnThreshold;
        this.checkpointTermInSecs = checkpointTermInSecs;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Checkpoint Thread (" + Thread.currentThread().getId() + ")");
        long lastCheckpointLSN = -1L;
        while (this.shouldRun) {
            try {
                long targetCheckpointLSN;
                long currentCheckpointAttemptMinLSN;
                CheckpointThread.sleep(this.checkpointTermInSecs * 1000L);
                if (!this.shouldRun) {
                    return;
                }
                if (lastCheckpointLSN == -1L) {
                    lastCheckpointLSN = this.logManager.getReadableSmallestLSN();
                }
                this.checkpointManager.checkpointIdleDatasets();
                long currentLogLSN = this.logManager.getAppendLSN();
                if (currentLogLSN - lastCheckpointLSN <= this.lsnThreshold || (currentCheckpointAttemptMinLSN = this.checkpointManager.tryCheckpoint(targetCheckpointLSN = lastCheckpointLSN + this.lsnThreshold)) < targetCheckpointLSN) continue;
                lastCheckpointLSN = currentCheckpointAttemptMinLSN;
            }
            catch (InterruptedException e) {
                LOGGER.info("Checkpoint thread interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("checkpoint attempt failed", (Throwable)e);
            }
        }
    }

    public void shutdown() {
        this.shouldRun = false;
    }
}

