/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.frames.AbstractSlotManager;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleMode;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleNoExactMatchPolicy;
import org.apache.hyracks.storage.am.rtree.frames.RTreeNSMFrame;
import org.apache.hyracks.storage.common.MultiComparator;

public class UnorderedSlotManager
extends AbstractSlotManager {
    public int findTupleIndex(ITupleReference searchKey, ITreeIndexTupleReference frameTuple, MultiComparator multiCmp, FindTupleMode mode, FindTupleNoExactMatchPolicy matchPolicy) throws HyracksDataException {
        if (searchKey.getFieldCount() == frameTuple.getFieldCount()) {
            int maxFieldPos = multiCmp.getKeyFieldCount() / 2;
            for (int i = 0; i < this.frame.getTupleCount(); ++i) {
                frameTuple.resetByTupleIndex(this.frame, i);
                boolean foundTuple = true;
                for (int j = 0; j < maxFieldPos; ++j) {
                    int k = maxFieldPos + j;
                    int c1 = multiCmp.getComparators()[j].compare(frameTuple.getFieldData(j), frameTuple.getFieldStart(j), frameTuple.getFieldLength(j), searchKey.getFieldData(j), searchKey.getFieldStart(j), searchKey.getFieldLength(j));
                    if (c1 != 0) {
                        foundTuple = false;
                        break;
                    }
                    int c2 = multiCmp.getComparators()[k].compare(frameTuple.getFieldData(k), frameTuple.getFieldStart(k), frameTuple.getFieldLength(k), searchKey.getFieldData(k), searchKey.getFieldStart(k), searchKey.getFieldLength(k));
                    if (c2 == 0) continue;
                    foundTuple = false;
                    break;
                }
                int remainingFieldCount = frameTuple.getFieldCount() - multiCmp.getKeyFieldCount();
                for (int j = multiCmp.getKeyFieldCount(); j < multiCmp.getKeyFieldCount() + remainingFieldCount; ++j) {
                    if (this.compareField(searchKey, frameTuple, j)) continue;
                    foundTuple = false;
                    break;
                }
                if (!foundTuple) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean compareField(ITupleReference searchKey, ITreeIndexTupleReference frameTuple, int fIdx) {
        int frameTupleFieldLength;
        int searchKeyFieldLength = searchKey.getFieldLength(fIdx);
        if (searchKeyFieldLength != (frameTupleFieldLength = frameTuple.getFieldLength(fIdx))) {
            return false;
        }
        for (int i = 0; i < searchKeyFieldLength; ++i) {
            if (searchKey.getFieldData(fIdx)[i + searchKey.getFieldStart(fIdx)] == frameTuple.getFieldData(fIdx)[i + frameTuple.getFieldStart(fIdx)]) continue;
            return false;
        }
        return true;
    }

    public int findTupleIndex(ITupleReference searchKey, ITreeIndexTupleReference pageTuple, MultiComparator cmp, int startIndex) {
        throw new UnsupportedOperationException("Stateful search is not supported by UnorderedSlotManager");
    }

    public int insertSlot(int tupleIndex, int tupleOff) {
        int slotOff = this.getSlotEndOff() - 4;
        this.setSlot(slotOff, tupleOff);
        return slotOff;
    }

    public void modifySlot(int slotOff, int tupleOff) {
        this.setSlot(slotOff, tupleOff);
    }

    public void deleteSlot(int slotOff) {
        System.arraycopy(this.frame.getBuffer().array(), this.getSlotEndOff(), this.frame.getBuffer().array(), slotOff + 4, 4);
    }

    public void deleteEmptySlots() {
        int slotOff = this.getSlotStartOff();
        while (this.frame.getTupleCount() > 0) {
            while (this.frame.getBuffer().getInt(this.getSlotEndOff()) == -1) {
                ((RTreeNSMFrame)this.frame).setTupleCount(this.frame.getTupleCount() - 1);
                if (this.frame.getTupleCount() != 0) continue;
            }
            if (this.frame.getTupleCount() == 0 || slotOff <= this.getSlotEndOff()) break;
            if (this.frame.getBuffer().getInt(slotOff) == -1) {
                this.modifySlot(slotOff, this.frame.getBuffer().getInt(this.getSlotEndOff()));
                ((RTreeNSMFrame)this.frame).setTupleCount(this.frame.getTupleCount() - 1);
            }
            slotOff -= 4;
        }
    }
}

