/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import java.io.IOException;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.common.AbstractAsterixListIterator;
import org.apache.asterix.runtime.evaluators.common.SimilarityJaccardEvaluator;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.BinaryEntry;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class SimilarityJaccardCheckEvaluator
extends SimilarityJaccardEvaluator {
    protected final IScalarEvaluator jaccThreshEval;
    protected float jaccThresh = -1.0f;
    protected IPointable jaccThreshPointable = new VoidPointable();
    protected OrderedListBuilder listBuilder;
    protected ArrayBackedValueStorage inputVal;
    protected final ISerializerDeserializer<ABoolean> booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
    protected final AOrderedListType listType = new AOrderedListType((IAType)BuiltinType.ANY, "list");

    public SimilarityJaccardCheckEvaluator(IScalarEvaluatorFactory[] args, IEvaluatorContext context) throws HyracksDataException {
        super(args, context);
        this.jaccThreshEval = args[2].createScalarEvaluator(context);
        this.listBuilder = new OrderedListBuilder();
        this.inputVal = new ArrayBackedValueStorage();
    }

    @Override
    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.firstOrdListEval.evaluate(tuple, this.argPtr1);
        this.secondOrdListEval.evaluate(tuple, this.argPtr2);
        this.jaccThreshEval.evaluate(tuple, this.jaccThreshPointable);
        if (PointableHelper.checkAndSetMissingOrNull((IPointable)result, (IPointable)this.argPtr1, (IPointable)this.argPtr2, (IPointable)this.jaccThreshPointable)) {
            return;
        }
        this.firstTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argPtr1.getByteArray()[this.argPtr1.getStartOffset()]);
        this.secondTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argPtr2.getByteArray()[this.argPtr2.getStartOffset()]);
        this.firstItemTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argPtr1.getByteArray()[this.argPtr1.getStartOffset() + 1]);
        this.secondItemTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argPtr2.getByteArray()[this.argPtr2.getStartOffset() + 1]);
        this.jaccThresh = AFloatSerializerDeserializer.getFloat((byte[])this.jaccThreshPointable.getByteArray(), (int)(this.jaccThreshPointable.getStartOffset() + 1));
        if (!this.checkArgTypes(this.firstTypeTag, this.secondTypeTag)) {
            result.set((IValueReference)this.resultStorage);
            return;
        }
        this.jaccSim = this.prepareLists(this.argPtr1, this.argPtr2) ? this.computeResult() : 0.0f;
        try {
            this.writeResult(this.jaccSim);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }

    @Override
    protected int probeHashMap(AbstractAsterixListIterator probeIter, int buildListSize, int probeListSize) throws HyracksDataException {
        int lengthLowerBound = (int)Math.ceil(this.jaccThresh * (float)probeListSize);
        if (lengthLowerBound > buildListSize || buildListSize > (int)Math.floor(1.0f / this.jaccThresh * (float)probeListSize)) {
            return -1;
        }
        int intersectionSize = 0;
        int probeListCount = 0;
        int minUnionSize = buildListSize;
        while (probeIter.hasNext()) {
            ++probeListCount;
            byte[] buf = probeIter.getData();
            int off = probeIter.getPos();
            int len = probeIter.getItemLen();
            this.keyEntry.set(buf, off, len);
            BinaryEntry entry = this.hashMap.get(this.keyEntry);
            if (entry != null) {
                int firstValInt = IntegerPointable.getInteger((byte[])entry.getBuf(), (int)entry.getOffset());
                if (firstValInt == 0) continue;
                int secondValInt = IntegerPointable.getInteger((byte[])entry.getBuf(), (int)(entry.getOffset() + 4));
                intersectionSize -= firstValInt < secondValInt ? firstValInt : secondValInt;
                intersectionSize += firstValInt < ++secondValInt ? firstValInt : secondValInt;
                IntegerPointable.setInteger((byte[])entry.getBuf(), (int)(entry.getOffset() + 4), (int)secondValInt);
            } else {
                int lowerBound;
                int maxIntersectionSize = Math.min(buildListSize, intersectionSize + (probeListSize - probeListCount));
                if (maxIntersectionSize < (lowerBound = (int)Math.floor(this.jaccThresh * (float)(++minUnionSize)))) {
                    return -1;
                }
            }
            probeIter.next();
        }
        return intersectionSize;
    }

    @Override
    protected void writeResult(float jacc) throws IOException {
        this.listBuilder.reset((AbstractCollectionType)this.listType);
        boolean matches = !(jacc < this.jaccThresh);
        this.inputVal.reset();
        this.booleanSerde.serialize((Object)(matches ? ABoolean.TRUE : ABoolean.FALSE), this.inputVal.getDataOutput());
        this.listBuilder.addItem((IValueReference)this.inputVal);
        this.inputVal.reset();
        this.aFloat.setValue(matches ? jacc : 0.0f);
        this.floatSerde.serialize((Object)this.aFloat, this.inputVal.getDataOutput());
        this.listBuilder.addItem((IValueReference)this.inputVal);
        this.listBuilder.write(this.out, true);
    }
}

