/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractAssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class IsomorphismVariableMappingVisitor
implements ILogicalOperatorVisitor<Void, ILogicalOperator> {
    private final Map<ILogicalOperator, Set<ILogicalOperator>> alreadyMapped;
    private final Map<LogicalVariable, LogicalVariable> variableMapping;
    private final boolean goThroughNts;

    IsomorphismVariableMappingVisitor(Map<LogicalVariable, LogicalVariable> variableMapping, boolean goThroughNts) {
        this.variableMapping = variableMapping;
        this.goThroughNts = goThroughNts;
        this.alreadyMapped = goThroughNts ? new HashMap() : null;
    }

    @Override
    public Void visitAggregateOperator(AggregateOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapChildren(op, arg);
        this.mapVariablesForAbstractAssign(op, arg);
        return null;
    }

    @Override
    public Void visitRunningAggregateOperator(RunningAggregateOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapChildren(op, arg);
        this.mapVariablesForAbstractAssign(op, arg);
        return null;
    }

    @Override
    public Void visitWindowOperator(WindowOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapChildren(op, arg);
        this.mapVariablesForWindow(op, arg);
        this.mapVariablesInNestedPlans(op, arg);
        return null;
    }

    @Override
    public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitGroupByOperator(GroupByOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapChildren(op, arg);
        this.mapVariablesForGroupBy(op, arg);
        this.mapVariablesInNestedPlans(op, arg);
        return null;
    }

    @Override
    public Void visitLimitOperator(LimitOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitInnerJoinOperator(InnerJoinOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, ILogicalOperator arg) throws AlgebricksException {
        if (op.getOperatorTag() != arg.getOperatorTag()) {
            return null;
        }
        if (!this.goThroughNts) {
            return null;
        }
        Set<ILogicalOperator> mappedOps = this.alreadyMapped.get(op);
        if (mappedOps != null && mappedOps.contains(arg)) {
            return null;
        }
        if (mappedOps == null) {
            mappedOps = new HashSet<ILogicalOperator>();
            this.alreadyMapped.put(op, mappedOps);
        }
        mappedOps.add(arg);
        ILogicalOperator inputToCreator1 = op.getSourceOperator();
        NestedTupleSourceOperator nts = (NestedTupleSourceOperator)arg;
        ILogicalOperator inputToCreator2 = nts.getSourceOperator();
        inputToCreator1.accept(this, inputToCreator2);
        return null;
    }

    @Override
    public Void visitOrderOperator(OrderOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitAssignOperator(AssignOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapChildren(op, arg);
        this.mapVariablesForAbstractAssign(op, arg);
        return null;
    }

    @Override
    public Void visitSelectOperator(SelectOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitProjectOperator(ProjectOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitReplicateOperator(ReplicateOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitSplitOperator(SplitOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitMaterializeOperator(MaterializeOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitScriptOperator(ScriptOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitSubplanOperator(SubplanOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapChildren(op, arg);
        this.mapVariablesInNestedPlans(op, arg);
        return null;
    }

    @Override
    public Void visitUnionOperator(UnionAllOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapChildren(op, arg);
        this.mapVariablesForUnion(op, arg);
        return null;
    }

    @Override
    public Void visitIntersectOperator(IntersectOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapChildren(op, arg);
        this.mapVariablesForIntersect(op, arg);
        return null;
    }

    @Override
    public Void visitUnnestOperator(UnnestOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitUnnestMapOperator(UnnestMapOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitDataScanOperator(DataSourceScanOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitDistinctOperator(DistinctOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitExchangeOperator(ExchangeOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitWriteOperator(WriteOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitDistributeResultOperator(DistributeResultOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitWriteResultOperator(WriteResultOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapChildren(op, arg);
        this.mapVariablesInNestedPlans(op, arg);
        return null;
    }

    @Override
    public Void visitTokenizeOperator(TokenizeOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitForwardOperator(ForwardOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitSinkOperator(SinkOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitDelegateOperator(DelegateOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    @Override
    public Void visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, ILogicalOperator arg) throws AlgebricksException {
        this.mapVariablesStandard(op, arg);
        return null;
    }

    private void mapChildren(ILogicalOperator op, ILogicalOperator opArg) throws AlgebricksException {
        if (op.getOperatorTag() != opArg.getOperatorTag()) {
            return;
        }
        List<Mutable<ILogicalOperator>> inputs = op.getInputs();
        List<Mutable<ILogicalOperator>> inputsArg = opArg.getInputs();
        if (inputs.size() != inputsArg.size()) {
            return;
        }
        for (int i = 0; i < inputs.size(); ++i) {
            ILogicalOperator input = (ILogicalOperator)inputs.get(i).getValue();
            ILogicalOperator inputArg = (ILogicalOperator)inputsArg.get(i).getValue();
            input.accept(this, inputArg);
        }
    }

    private void mapVariables(ILogicalOperator left, ILogicalOperator right) throws AlgebricksException {
        if (left.getOperatorTag() != right.getOperatorTag()) {
            return;
        }
        ArrayList<LogicalVariable> producedVarLeft = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> producedVarRight = new ArrayList<LogicalVariable>();
        VariableUtilities.getProducedVariables(left, producedVarLeft);
        VariableUtilities.getProducedVariables(right, producedVarRight);
        this.mapVariables(producedVarLeft, producedVarRight);
    }

    private void mapVariables(List<LogicalVariable> variablesLeft, List<LogicalVariable> variablesRight) {
        if (variablesLeft.size() != variablesRight.size()) {
            return;
        }
        int size = variablesLeft.size();
        for (int i = 0; i < size; ++i) {
            LogicalVariable left = variablesLeft.get(i);
            LogicalVariable right = variablesRight.get(i);
            this.variableMapping.put(right, left);
        }
    }

    private void mapVariablesForAbstractAssign(ILogicalOperator left, ILogicalOperator right) throws AlgebricksException {
        if (left.getOperatorTag() != right.getOperatorTag()) {
            return;
        }
        AbstractAssignOperator leftOp = (AbstractAssignOperator)left;
        AbstractAssignOperator rightOp = (AbstractAssignOperator)right;
        ArrayList<LogicalVariable> producedVarLeft = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> producedVarRight = new ArrayList<LogicalVariable>();
        VariableUtilities.getProducedVariables(left, producedVarLeft);
        VariableUtilities.getProducedVariables(right, producedVarRight);
        this.mapVariablesForAbstractAssign(producedVarLeft, leftOp.getExpressions(), producedVarRight, rightOp.getExpressions());
    }

    private void mapVariablesForGroupBy(ILogicalOperator left, ILogicalOperator right) {
        if (left.getOperatorTag() != right.getOperatorTag()) {
            return;
        }
        GroupByOperator leftOp = (GroupByOperator)left;
        GroupByOperator rightOp = (GroupByOperator)right;
        List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> leftPairs = leftOp.getGroupByList();
        List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> rightPairs = rightOp.getGroupByList();
        this.mapVarExprPairList(leftPairs, rightPairs);
        leftPairs = leftOp.getDecorList();
        rightPairs = rightOp.getDecorList();
        this.mapVarExprPairList(leftPairs, rightPairs);
    }

    private void mapVariablesForWindow(ILogicalOperator left, ILogicalOperator right) {
        if (left.getOperatorTag() != right.getOperatorTag()) {
            return;
        }
        WindowOperator leftOp = (WindowOperator)left;
        WindowOperator rightOp = (WindowOperator)right;
        this.mapVariablesForAbstractAssign(leftOp.getVariables(), leftOp.getExpressions(), rightOp.getVariables(), rightOp.getExpressions());
    }

    private void mapVarExprPairList(List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> leftPairs, List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> rightPairs) {
        if (leftPairs.size() != rightPairs.size()) {
            return;
        }
        block0: for (int i = 0; i < leftPairs.size(); ++i) {
            ILogicalExpression exprLeft = (ILogicalExpression)((Mutable)leftPairs.get((int)i).second).getValue();
            LogicalVariable leftVar = (LogicalVariable)leftPairs.get((int)i).first;
            for (int j = 0; j < leftPairs.size(); ++j) {
                ILogicalExpression exprRight = (ILogicalExpression)this.copyExpressionAndSubtituteVars((Mutable<ILogicalExpression>)((Mutable)rightPairs.get((int)j).second)).getValue();
                if (!exprLeft.equals(exprRight)) continue;
                LogicalVariable rightVar = (LogicalVariable)rightPairs.get((int)j).first;
                if (rightVar == null || leftVar == null) continue block0;
                this.variableMapping.put(rightVar, leftVar);
                continue block0;
            }
        }
    }

    private void mapVariablesForAbstractAssign(List<LogicalVariable> variablesLeft, List<Mutable<ILogicalExpression>> exprsLeft, List<LogicalVariable> variablesRight, List<Mutable<ILogicalExpression>> exprsRight) {
        if (variablesLeft.size() != variablesRight.size()) {
            return;
        }
        int size = variablesLeft.size();
        HashSet<LogicalVariable> matchedRightVars = new HashSet<LogicalVariable>();
        block0: for (int i = 0; i < size; ++i) {
            ILogicalExpression exprLeft = (ILogicalExpression)exprsLeft.get(i).getValue();
            LogicalVariable left = variablesLeft.get(i);
            for (int j = 0; j < size; ++j) {
                ILogicalExpression exprRight = (ILogicalExpression)this.copyExpressionAndSubtituteVars(exprsRight.get(j)).getValue();
                LogicalVariable right = variablesRight.get(j);
                if (!exprLeft.equals(exprRight) || matchedRightVars.contains(right)) continue;
                this.variableMapping.put(right, left);
                matchedRightVars.add(right);
                continue block0;
            }
        }
    }

    private void mapVariablesInNestedPlans(AbstractOperatorWithNestedPlans op, ILogicalOperator arg) throws AlgebricksException {
        if (op.getOperatorTag() != arg.getOperatorTag()) {
            return;
        }
        AbstractOperatorWithNestedPlans argOp = (AbstractOperatorWithNestedPlans)arg;
        List<ILogicalPlan> plans = op.getNestedPlans();
        List<ILogicalPlan> plansArg = argOp.getNestedPlans();
        if (plans.size() != plansArg.size()) {
            return;
        }
        for (int i = 0; i < plans.size(); ++i) {
            List<Mutable<ILogicalOperator>> roots = plans.get(i).getRoots();
            List<Mutable<ILogicalOperator>> rootsArg = plansArg.get(i).getRoots();
            if (roots.size() != rootsArg.size()) {
                return;
            }
            for (int j = 0; j < roots.size(); ++j) {
                ILogicalOperator topOp1 = (ILogicalOperator)roots.get(j).getValue();
                ILogicalOperator topOp2 = (ILogicalOperator)rootsArg.get(j).getValue();
                topOp1.accept(this, topOp2);
            }
        }
    }

    private void mapVariablesStandard(ILogicalOperator op, ILogicalOperator arg) throws AlgebricksException {
        if (op.getOperatorTag() != arg.getOperatorTag()) {
            return;
        }
        this.mapChildren(op, arg);
        this.mapVariables(op, arg);
    }

    private Mutable<ILogicalExpression> copyExpressionAndSubtituteVars(Mutable<ILogicalExpression> expr) {
        ILogicalExpression copy = ((ILogicalExpression)expr.getValue()).cloneExpression();
        this.variableMapping.forEach(copy::substituteVar);
        return new MutableObject((Object)copy);
    }

    private void mapVariablesForUnion(ILogicalOperator op, ILogicalOperator arg) {
        if (op.getOperatorTag() != arg.getOperatorTag()) {
            return;
        }
        UnionAllOperator union = (UnionAllOperator)op;
        UnionAllOperator unionArg = (UnionAllOperator)arg;
        this.mapVarTripleList(union.getVariableMappings(), unionArg.getVariableMappings());
    }

    private void mapVarTripleList(List<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> leftTriples, List<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> rightTriples) {
        if (leftTriples.size() != rightTriples.size()) {
            return;
        }
        block0: for (int i = 0; i < leftTriples.size(); ++i) {
            LogicalVariable leftFirstVar = (LogicalVariable)leftTriples.get((int)i).first;
            LogicalVariable leftSecondVar = (LogicalVariable)leftTriples.get((int)i).second;
            LogicalVariable leftThirdVar = (LogicalVariable)leftTriples.get((int)i).third;
            for (int j = 0; j < rightTriples.size(); ++j) {
                LogicalVariable rightFirstVar = (LogicalVariable)rightTriples.get((int)j).first;
                LogicalVariable rightSecondVar = (LogicalVariable)rightTriples.get((int)j).second;
                LogicalVariable rightThirdVar = (LogicalVariable)rightTriples.get((int)j).third;
                if (!this.varEquivalent(leftFirstVar, rightFirstVar) || !this.varEquivalent(leftSecondVar, rightSecondVar)) continue;
                this.variableMapping.put(rightThirdVar, leftThirdVar);
                continue block0;
            }
        }
    }

    private void mapVariablesForIntersect(IntersectOperator op, ILogicalOperator arg) {
        if (op.getOperatorTag() != arg.getOperatorTag()) {
            return;
        }
        IntersectOperator opArg = (IntersectOperator)arg;
        int nInput = op.getNumInput();
        if (nInput != opArg.getNumInput()) {
            return;
        }
        boolean hasExtraVars = op.hasExtraVariables();
        if (hasExtraVars && !opArg.hasExtraVariables()) {
            return;
        }
        for (int i = 0; i < nInput; ++i) {
            List<LogicalVariable> inputCompareVars = op.getInputCompareVariables(i);
            List<LogicalVariable> inputCompareVarsArg = opArg.getInputCompareVariables(i);
            int n = inputCompareVars.size();
            for (int j = 0; j < n; ++j) {
                if (this.varEquivalent(inputCompareVars.get(j), inputCompareVarsArg.get(j))) continue;
                return;
            }
            if (!hasExtraVars) continue;
            List<LogicalVariable> inputExtraVars = op.getInputExtraVariables(i);
            List<LogicalVariable> inputExtraVarsArg = opArg.getInputExtraVariables(i);
            int n2 = inputExtraVars.size();
            for (int j = 0; j < n2; ++j) {
                if (this.varEquivalent(inputExtraVars.get(j), inputExtraVarsArg.get(j))) continue;
                return;
            }
        }
        this.mapVariables(op.getOutputCompareVariables(), opArg.getOutputCompareVariables());
        if (hasExtraVars) {
            this.mapVariables(op.getOutputExtraVariables(), opArg.getOutputExtraVariables());
        }
    }

    private boolean varEquivalent(LogicalVariable left, LogicalVariable right) {
        if (this.variableMapping.get(right) == null) {
            return false;
        }
        return this.variableMapping.get(right).equals(left);
    }
}

