/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class BuiltinTypeMap {
    private static final Map<String, BuiltinType> _builtinTypeMap = new HashMap<String, BuiltinType>();

    private BuiltinTypeMap() {
    }

    public static BuiltinType getBuiltinType(String typeName) {
        return _builtinTypeMap.get(typeName.toLowerCase());
    }

    public static Set<BuiltinType> getAllBuiltinTypes() {
        return new HashSet<BuiltinType>(_builtinTypeMap.values());
    }

    public static IAType getTypeFromTypeName(MetadataNode metadataNode, TxnId txnId, DataverseName dataverseName, String typeName) throws AlgebricksException {
        Datatype dt;
        IAType type = (IAType)_builtinTypeMap.get(typeName);
        if (type == null && (dt = metadataNode.getDatatype(txnId, dataverseName, typeName)) != null) {
            type = dt.getDatatype();
        }
        return type;
    }

    static {
        _builtinTypeMap.put("int8", BuiltinType.AINT8);
        _builtinTypeMap.put("int16", BuiltinType.AINT16);
        _builtinTypeMap.put("int32", BuiltinType.AINT32);
        _builtinTypeMap.put("int64", BuiltinType.AINT64);
        _builtinTypeMap.put("year-month-duration", BuiltinType.AYEARMONTHDURATION);
        _builtinTypeMap.put("day-time-duration", BuiltinType.ADAYTIMEDURATION);
        _builtinTypeMap.put("boolean", BuiltinType.ABOOLEAN);
        _builtinTypeMap.put("tinyint", BuiltinType.AINT8);
        _builtinTypeMap.put("smallint", BuiltinType.AINT16);
        _builtinTypeMap.put("integer", BuiltinType.AINT32);
        _builtinTypeMap.put("int", BuiltinType.AINT32);
        _builtinTypeMap.put("bigint", BuiltinType.AINT64);
        _builtinTypeMap.put("float", BuiltinType.AFLOAT);
        _builtinTypeMap.put("double", BuiltinType.ADOUBLE);
        _builtinTypeMap.put("double precision", BuiltinType.ADOUBLE);
        _builtinTypeMap.put("string", BuiltinType.ASTRING);
        _builtinTypeMap.put("binary", BuiltinType.ABINARY);
        _builtinTypeMap.put("date", BuiltinType.ADATE);
        _builtinTypeMap.put("time", BuiltinType.ATIME);
        _builtinTypeMap.put("datetime", BuiltinType.ADATETIME);
        _builtinTypeMap.put("timestamp", BuiltinType.ADATETIME);
        _builtinTypeMap.put("duration", BuiltinType.ADURATION);
        _builtinTypeMap.put("year_month_duration", BuiltinType.AYEARMONTHDURATION);
        _builtinTypeMap.put("day_time_duration", BuiltinType.ADAYTIMEDURATION);
        _builtinTypeMap.put("interval", BuiltinType.AINTERVAL);
        _builtinTypeMap.put("point", BuiltinType.APOINT);
        _builtinTypeMap.put("point3d", BuiltinType.APOINT3D);
        _builtinTypeMap.put("line", BuiltinType.ALINE);
        _builtinTypeMap.put("polygon", BuiltinType.APOLYGON);
        _builtinTypeMap.put("circle", BuiltinType.ACIRCLE);
        _builtinTypeMap.put("rectangle", BuiltinType.ARECTANGLE);
        _builtinTypeMap.put("missing", BuiltinType.AMISSING);
        _builtinTypeMap.put("null", BuiltinType.ANULL);
        _builtinTypeMap.put("uuid", BuiltinType.AUUID);
        _builtinTypeMap.put("shortwithouttypeinfo", BuiltinType.SHORTWITHOUTTYPEINFO);
        _builtinTypeMap.put("geometry", BuiltinType.AGEOMETRY);
    }
}

