/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.List;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.rewriter.rules.ConsolidateWindowOperatorsRule;

public final class AsterixConsolidateWindowOperatorsRule
extends ConsolidateWindowOperatorsRule {
    protected boolean subsumeFrameMaxObjects(int maxObjects1, int maxObjects2, AggregateOperator aggOp2) {
        if (this.allFunctionCalls(aggOp2.getExpressions(), BuiltinFunctions.FIRST_ELEMENT) && maxObjects2 >= 1 && (maxObjects1 == -1 || maxObjects1 >= maxObjects2)) {
            return true;
        }
        return super.subsumeFrameMaxObjects(maxObjects1, maxObjects2, aggOp2);
    }

    private boolean allFunctionCalls(List<Mutable<ILogicalExpression>> exprRefs, FunctionIdentifier fid) {
        for (Mutable<ILogicalExpression> exprRef : exprRefs) {
            ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                return false;
            }
            AbstractFunctionCallExpression callExpr = (AbstractFunctionCallExpression)expr;
            if (callExpr.getFunctionIdentifier().equals((Object)fid)) continue;
            return false;
        }
        return true;
    }
}

