/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.com.job.profiling.counters.Counter;
import org.apache.hyracks.api.comm.IPartitionCollector;
import org.apache.hyracks.api.comm.PartitionChannel;
import org.apache.hyracks.api.context.IHyracksJobletContext;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IWorkspaceFileFactory;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.IGlobalJobDataFactory;
import org.apache.hyracks.api.job.IJobletEventListener;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.IOperatorEnvironment;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.job.profiling.IStatsCollector;
import org.apache.hyracks.api.job.profiling.counters.ICounter;
import org.apache.hyracks.api.job.profiling.counters.ICounterContext;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.api.resources.IDeallocatable;
import org.apache.hyracks.api.resources.IDeallocatableRegistry;
import org.apache.hyracks.control.common.deployment.DeploymentUtils;
import org.apache.hyracks.control.common.job.PartitionRequest;
import org.apache.hyracks.control.common.job.PartitionState;
import org.apache.hyracks.control.common.job.profiling.StatsCollector;
import org.apache.hyracks.control.common.job.profiling.om.JobletProfile;
import org.apache.hyracks.control.common.job.profiling.om.PartitionProfile;
import org.apache.hyracks.control.common.job.profiling.om.TaskProfile;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.Task;
import org.apache.hyracks.control.nc.io.WorkspaceFileFactory;
import org.apache.hyracks.control.nc.resources.DefaultDeallocatableRegistry;
import org.apache.hyracks.control.nc.resources.memory.FrameManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Joblet
implements IHyracksJobletContext,
ICounterContext {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NodeControllerService nodeController;
    private final INCServiceContext serviceCtx;
    private final DeploymentId deploymentId;
    private final JobId jobId;
    private final ActivityClusterGraph acg;
    private final Map<PartitionId, IPartitionCollector> partitionRequestMap;
    private final IOperatorEnvironment env;
    private final Map<Object, IStateObject> stateObjectMap;
    private final Map<TaskAttemptId, Task> taskMap;
    private final Map<String, Counter> counterMap;
    private final DefaultDeallocatableRegistry deallocatableRegistry;
    private final IWorkspaceFileFactory fileFactory;
    private final Object globalJobData;
    private final IJobletEventListener jobletEventListener;
    private final FrameManager frameManager;
    private final AtomicLong memoryAllocation;
    private JobStatus cleanupStatus;
    private boolean cleanupPending;
    private final IJobletEventListenerFactory jobletEventListenerFactory;
    private final long jobStartTime;
    private final String jobStartTimeZoneId;
    private final long maxWarnings;

    public Joblet(NodeControllerService nodeController, DeploymentId deploymentId, JobId jobId, INCServiceContext serviceCtx, ActivityClusterGraph acg, IJobletEventListenerFactory jobletEventListenerFactory, long jobStartTime, String jobStartTimeZoneId) {
        this.nodeController = nodeController;
        this.serviceCtx = serviceCtx;
        this.deploymentId = deploymentId;
        this.jobId = jobId;
        this.frameManager = new FrameManager(acg.getFrameSize());
        this.memoryAllocation = new AtomicLong();
        this.acg = acg;
        this.partitionRequestMap = new HashMap<PartitionId, IPartitionCollector>();
        this.env = new OperatorEnvironmentImpl(nodeController.getId());
        this.stateObjectMap = new HashMap<Object, IStateObject>();
        this.taskMap = new HashMap<TaskAttemptId, Task>();
        this.counterMap = new HashMap<String, Counter>();
        this.deallocatableRegistry = new DefaultDeallocatableRegistry();
        this.fileFactory = new WorkspaceFileFactory((IDeallocatableRegistry)this, serviceCtx.getIoManager());
        this.cleanupPending = false;
        this.jobletEventListenerFactory = jobletEventListenerFactory;
        if (jobletEventListenerFactory != null) {
            IJobletEventListener listener;
            this.jobletEventListener = listener = jobletEventListenerFactory.createListener((IHyracksJobletContext)this);
            listener.jobletStart();
        } else {
            this.jobletEventListener = null;
        }
        IGlobalJobDataFactory gjdf = acg.getGlobalJobDataFactory();
        this.globalJobData = gjdf != null ? gjdf.createGlobalJobData((IHyracksJobletContext)this) : null;
        this.jobStartTime = jobStartTime;
        this.jobStartTimeZoneId = jobStartTimeZoneId;
        this.maxWarnings = acg.getMaxWarnings();
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public IJobletEventListenerFactory getJobletEventListenerFactory() {
        return this.jobletEventListenerFactory;
    }

    public ActivityClusterGraph getActivityClusterGraph() {
        return this.acg;
    }

    public IOperatorEnvironment getEnvironment() {
        return this.env;
    }

    public long getJobStartTime() {
        return this.jobStartTime;
    }

    public String getJobStartTimeZoneId() {
        return this.jobStartTimeZoneId;
    }

    public void addTask(Task task) {
        this.taskMap.put(task.getTaskAttemptId(), task);
    }

    public void removeTask(Task task) {
        this.taskMap.remove(task.getTaskAttemptId());
        if (this.cleanupPending && this.taskMap.isEmpty()) {
            this.performCleanup();
        }
    }

    public Map<TaskAttemptId, Task> getTaskMap() {
        return this.taskMap;
    }

    public NodeControllerService getNodeController() {
        return this.nodeController;
    }

    public void dumpProfile(JobletProfile jProfile) {
        Map counters = jProfile.getCounters();
        this.counterMap.forEach((key, value) -> counters.put(key, value.get()));
        for (Task task : this.taskMap.values()) {
            TaskProfile taskProfile = new TaskProfile(task.getTaskAttemptId(), new Hashtable<PartitionId, PartitionProfile>(task.getPartitionSendProfile()), (IStatsCollector)new StatsCollector(), task.getWarnings(), task.getWarningCollector().getTotalWarningsCount());
            task.dumpProfile(taskProfile);
            jProfile.getTaskProfiles().put(task.getTaskAttemptId(), taskProfile);
        }
    }

    public INCServiceContext getServiceContext() {
        return this.serviceCtx;
    }

    public ICounterContext getCounterContext() {
        return this;
    }

    public void registerDeallocatable(IDeallocatable deallocatable) {
        this.deallocatableRegistry.registerDeallocatable(deallocatable);
    }

    public void close() {
        long stillAllocated = this.memoryAllocation.get();
        if (stillAllocated > 0L) {
            LOGGER.trace(() -> "Freeing leaked " + stillAllocated + " bytes");
            this.serviceCtx.getMemoryManager().deallocate(stillAllocated);
        }
        this.nodeController.getExecutor().execute(() -> this.deallocatableRegistry.close());
    }

    public ByteBuffer allocateFrame() throws HyracksDataException {
        return this.frameManager.allocateFrame();
    }

    public ByteBuffer allocateFrame(int bytes) throws HyracksDataException {
        if (this.serviceCtx.getMemoryManager().allocate((long)bytes)) {
            this.memoryAllocation.addAndGet(bytes);
            return this.frameManager.allocateFrame(bytes);
        }
        throw new HyracksDataException("Unable to allocate frame: Not enough memory");
    }

    public ByteBuffer reallocateFrame(ByteBuffer usedBuffer, int newFrameSizeInBytes, boolean copyOldData) throws HyracksDataException {
        return this.frameManager.reallocateFrame(usedBuffer, newFrameSizeInBytes, copyOldData);
    }

    public void deallocateFrames(int bytes) {
        this.memoryAllocation.addAndGet(bytes);
        this.serviceCtx.getMemoryManager().deallocate((long)bytes);
        this.frameManager.deallocateFrames(bytes);
    }

    public final int getInitialFrameSize() {
        return this.frameManager.getInitialFrameSize();
    }

    public final long getMaxWarnings() {
        return this.maxWarnings;
    }

    public IIOManager getIoManager() {
        return this.serviceCtx.getIoManager();
    }

    public FileReference createManagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createManagedWorkspaceFile(prefix);
    }

    public FileReference createUnmanagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createUnmanagedWorkspaceFile(prefix);
    }

    public synchronized ICounter getCounter(String name, boolean create) {
        Counter counter = this.counterMap.get(name);
        if (counter == null && create) {
            counter = new Counter(name);
            this.counterMap.put(name, counter);
        }
        return counter;
    }

    public Object getGlobalJobData() {
        return this.globalJobData;
    }

    public IJobletEventListener getJobletEventListener() {
        return this.jobletEventListener;
    }

    public synchronized void advertisePartitionRequest(TaskAttemptId taId, Collection<PartitionId> pids, IPartitionCollector collector, PartitionState minState) throws Exception {
        for (PartitionId pid : pids) {
            this.partitionRequestMap.put(pid, collector);
            PartitionRequest req = new PartitionRequest(pid, this.nodeController.getId(), taId, minState);
            this.nodeController.getClusterController(this.jobId.getCcId()).registerPartitionRequest(req);
        }
    }

    public synchronized void reportPartitionAvailability(PartitionChannel channel) throws HyracksException {
        IPartitionCollector collector = this.partitionRequestMap.get(channel.getPartitionId());
        if (collector != null) {
            collector.addPartitions(Collections.singleton(channel));
        }
    }

    public void cleanup(JobStatus status) {
        this.cleanupStatus = status;
        this.cleanupPending = true;
        if (this.taskMap.isEmpty()) {
            this.performCleanup();
        }
    }

    private void performCleanup() {
        this.nodeController.getJobletMap().remove(this.jobId);
        IJobletEventListener listener = this.getJobletEventListener();
        if (listener != null) {
            listener.jobletFinish(this.cleanupStatus);
        }
        this.close();
        this.cleanupPending = false;
        try {
            this.nodeController.getClusterController(this.jobId.getCcId()).notifyJobletCleanup(this.jobId, this.nodeController.getId());
        }
        catch (Exception e) {
            LOGGER.info((Object)e);
        }
    }

    public Class<?> loadClass(String className) throws HyracksException {
        return DeploymentUtils.loadClass((String)className, (DeploymentId)this.deploymentId, (IServiceContext)this.serviceCtx);
    }

    public ClassLoader getClassLoader() throws HyracksException {
        return DeploymentUtils.getClassLoader((DeploymentId)this.deploymentId, (IServiceContext)this.serviceCtx);
    }

    private final class OperatorEnvironmentImpl
    implements IOperatorEnvironment {
        private final String nodeId;

        public OperatorEnvironmentImpl(String nodeId) {
            this.nodeId = nodeId;
        }

        public String toString() {
            return super.toString() + "@" + this.nodeId;
        }

        public synchronized void setStateObject(IStateObject taskState) {
            Joblet.this.stateObjectMap.put(taskState.getId(), taskState);
        }

        public synchronized IStateObject getStateObject(Object id) {
            return Joblet.this.stateObjectMap.get(id);
        }
    }
}

