/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.formats.nontagged;

import org.apache.asterix.dataflow.data.common.AListElementTokenFactory;
import org.apache.asterix.dataflow.data.common.AOrderedListBinaryTokenizerFactory;
import org.apache.asterix.dataflow.data.common.AUnorderedListBinaryTokenizerFactory;
import org.apache.asterix.dataflow.data.common.IBinaryTokenizerFactoryProvider;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.DelimitedUTF8StringBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.HashedUTF8WordTokenFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.ITokenFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.NGramUTF8StringBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.UTF8NGramTokenFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.UTF8WordTokenFactory;

public class BinaryTokenizerFactoryProvider
implements IBinaryTokenizerFactoryProvider {
    public static final BinaryTokenizerFactoryProvider INSTANCE = new BinaryTokenizerFactoryProvider();
    private static final IBinaryTokenizerFactory stringTokenizerFactory = new DelimitedUTF8StringBinaryTokenizerFactory(true, true, (ITokenFactory)new UTF8WordTokenFactory(ATypeTag.SERIALIZED_STRING_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG));
    private static final IBinaryTokenizerFactory stringNoTypeTagTokenizerFactory = new DelimitedUTF8StringBinaryTokenizerFactory(true, false, (ITokenFactory)new UTF8WordTokenFactory(ATypeTag.STRING.serialize(), ATypeTag.INTEGER.serialize()));
    private static final IBinaryTokenizerFactory stringHashingTokenizerFactory = new DelimitedUTF8StringBinaryTokenizerFactory(true, true, (ITokenFactory)new HashedUTF8WordTokenFactory(ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG));
    private static final IBinaryTokenizerFactory orderedListTokenizerFactory = new AOrderedListBinaryTokenizerFactory(new AListElementTokenFactory());
    private static final IBinaryTokenizerFactory unorderedListTokenizerFactory = new AUnorderedListBinaryTokenizerFactory(new AListElementTokenFactory());

    @Override
    public IBinaryTokenizerFactory getWordTokenizerFactory(ATypeTag typeTag, boolean hashedTokens, boolean typeTageAlreadyRemoved) {
        switch (typeTag) {
            case STRING: {
                if (hashedTokens) {
                    return stringHashingTokenizerFactory;
                }
                if (!typeTageAlreadyRemoved) {
                    return stringTokenizerFactory;
                }
                return stringNoTypeTagTokenizerFactory;
            }
            case ARRAY: {
                return orderedListTokenizerFactory;
            }
            case MULTISET: {
                return unorderedListTokenizerFactory;
            }
        }
        return null;
    }

    @Override
    public IBinaryTokenizerFactory getNGramTokenizerFactory(ATypeTag typeTag, int gramLength, boolean usePrePost, boolean hashedTokens) {
        switch (typeTag) {
            case STRING: {
                if (hashedTokens) {
                    return null;
                }
                return new NGramUTF8StringBinaryTokenizerFactory(gramLength, usePrePost, true, true, (ITokenFactory)new UTF8NGramTokenFactory(ATypeTag.SERIALIZED_STRING_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG));
            }
            case ARRAY: {
                return orderedListTokenizerFactory;
            }
            case MULTISET: {
                return unorderedListTokenizerFactory;
            }
        }
        return null;
    }
}

