/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class ABinary
implements IAObject {
    private static final int HASH_PREFIX = 31;
    protected byte[] bytes;
    protected int start;
    protected int length;

    public ABinary(byte[] byteArray) {
        this.bytes = byteArray;
        this.start = 0;
        this.length = byteArray.length;
    }

    public ABinary(byte[] byteArray, int start, int length) {
        this.bytes = byteArray;
        this.start = start;
        this.length = length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public IAType getType() {
        return BuiltinType.ABINARY;
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        if (!(obj instanceof ABinary)) {
            return false;
        }
        byte[] x = ((ABinary)obj).getBytes();
        int xStart = ((ABinary)obj).getStart();
        int xLength = ((ABinary)obj).getLength();
        if (this.getLength() != xLength) {
            return false;
        }
        for (int k = 0; k < xLength; ++k) {
            if (this.bytes[this.start + k] == x[xStart + k]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hash() {
        int m = Math.min(31, this.getLength());
        int h = 0;
        for (int i = 0; i < m; ++i) {
            h += 31 * h + this.bytes[this.start + i];
        }
        return h;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int start = this.getStart();
        sb.append("0b");
        for (int i = 0; i < this.getLength(); ++i) {
            sb.append(this.bytes[start + i]);
        }
        return sb.toString();
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        int start = this.getStart();
        ArrayNode byteArray = om.createArrayNode();
        for (int i = 0; i < this.getLength(); ++i) {
            byteArray.add((short)this.bytes[start + i]);
        }
        json.set("ABinary", (JsonNode)byteArray);
        return json;
    }
}

