/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.visitor;

import java.util.List;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.IATypeVisitor;

public class SimpleStringBuilderForIATypeVisitor
implements IATypeVisitor<Void, StringBuilder> {
    @Override
    public Void visit(ARecordType recordType, StringBuilder arg) {
        String[] fieldNames = recordType.getFieldNames();
        IAType[] fieldTypes = recordType.getFieldTypes();
        arg.append("{");
        for (int i = 0; i < fieldNames.length; ++i) {
            if (i > 0) {
                arg.append(',');
            }
            arg.append(fieldNames[i]);
            arg.append(':');
            fieldTypes[i].accept(this, arg);
        }
        arg.append("}");
        return null;
    }

    @Override
    public Void visit(AbstractCollectionType collectionType, StringBuilder arg) {
        IAType itemType = collectionType.getItemType();
        arg.append(collectionType.getTypeTag() == ATypeTag.ARRAY ? "[" : "{{");
        itemType.accept(this, arg);
        arg.append(collectionType.getTypeTag() == ATypeTag.ARRAY ? "]" : "}}");
        return null;
    }

    @Override
    public Void visit(AUnionType unionType, StringBuilder arg) {
        List<IAType> unionList = unionType.getUnionList();
        arg.append("<");
        for (int i = 0; i < unionList.size(); ++i) {
            if (i > 0) {
                arg.append(',');
            }
            unionList.get(i).accept(this, arg);
        }
        arg.append(">");
        return null;
    }

    @Override
    public Void visitFlat(IAType flatType, StringBuilder arg) {
        arg.append(flatType.getTypeTag());
        return null;
    }
}

