/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.ogc.OGCGeometry;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AGeometrySerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AGeometry;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractSTDoubleGeometryDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    protected abstract Object evaluateOGCGeometry(OGCGeometry var1, OGCGeometry var2) throws HyracksDataException;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new AbstractSTDoubleGeometryEvaluator(args, ctx);
            }
        };
    }

    private class AbstractSTDoubleGeometryEvaluator
    implements IScalarEvaluator {
        private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
        private final DataOutput out = this.resultStorage.getDataOutput();
        private final IPointable argPtr0 = new VoidPointable();
        private final IPointable argPtr1 = new VoidPointable();
        private final IScalarEvaluator eval0;
        private final IScalarEvaluator eval1;

        public AbstractSTDoubleGeometryEvaluator(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            this.eval0 = args[0].createScalarEvaluator(ctx);
            this.eval1 = args[1].createScalarEvaluator(ctx);
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            this.resultStorage.reset();
            this.eval0.evaluate(tuple, this.argPtr0);
            this.eval1.evaluate(tuple, this.argPtr1);
            try {
                DataInputStream dataIn1;
                OGCGeometry geometry1;
                byte[] bytes0 = this.argPtr0.getByteArray();
                int offset0 = this.argPtr0.getStartOffset();
                int len0 = this.argPtr0.getLength();
                byte[] bytes1 = this.argPtr1.getByteArray();
                int offset1 = this.argPtr1.getStartOffset();
                int len1 = this.argPtr1.getLength();
                ATypeTag tag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes0[offset0]);
                if (tag != ATypeTag.GEOMETRY) {
                    throw new TypeMismatchException(AbstractSTDoubleGeometryDescriptor.this.sourceLoc, AbstractSTDoubleGeometryDescriptor.this.getIdentifier(), 0, bytes0[offset0], new byte[]{ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG});
                }
                tag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes1[offset1]);
                if (tag != ATypeTag.GEOMETRY) {
                    throw new TypeMismatchException(AbstractSTDoubleGeometryDescriptor.this.sourceLoc, AbstractSTDoubleGeometryDescriptor.this.getIdentifier(), 0, bytes1[offset1], new byte[]{ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG});
                }
                DataInputStream dataIn0 = new DataInputStream(new ByteArrayInputStream(bytes0, offset0 + 1, len0 - 1));
                OGCGeometry geometry0 = AGeometrySerializerDeserializer.INSTANCE.deserialize((DataInput)dataIn0).getGeometry();
                Object finalResult = AbstractSTDoubleGeometryDescriptor.this.evaluateOGCGeometry(geometry0, geometry1 = AGeometrySerializerDeserializer.INSTANCE.deserialize((DataInput)(dataIn1 = new DataInputStream(new ByteArrayInputStream(bytes1, offset1 + 1, len1 - 1)))).getGeometry());
                if (finalResult instanceof OGCGeometry) {
                    this.out.writeByte(ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG);
                    AGeometrySerializerDeserializer.INSTANCE.serialize(new AGeometry((OGCGeometry)finalResult), this.out);
                } else if (finalResult instanceof Boolean) {
                    SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN).serialize((Object)((Boolean)finalResult != false ? ABoolean.TRUE : ABoolean.FALSE), this.out);
                } else if (finalResult instanceof Double) {
                    this.out.writeByte(ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
                    this.out.writeDouble((Double)finalResult);
                }
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            result.set((IValueReference)this.resultStorage);
        }
    }
}

