/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.comparators;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.asterix.dataflow.data.nontagged.serde.AGeometrySerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.om.base.AGeometry;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public class AGeometryPartialBinaryComparatorFactory
implements IBinaryComparatorFactory {
    private static final long serialVersionUID = 1L;
    public static final AGeometryPartialBinaryComparatorFactory INSTANCE = new AGeometryPartialBinaryComparatorFactory();

    private AGeometryPartialBinaryComparatorFactory() {
    }

    public IBinaryComparator createBinaryComparator() {
        return AGeometryPartialBinaryComparatorFactory::compare;
    }

    public static int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) throws HyracksDataException {
        int geometrySize = AInt32SerializerDeserializer.getInt(b1, s1 + AGeometrySerializerDeserializer.getAGeometrySizeOffset());
        int c = Integer.compare(geometrySize, AInt32SerializerDeserializer.getInt(b2, s2 + AGeometrySerializerDeserializer.getAGeometrySizeOffset()));
        if (c == 0) {
            AGeometry geometry = AGeometrySerializerDeserializer.getAGeometryObject(b1, s1);
            c = geometry.getGeometry().Equals(AGeometrySerializerDeserializer.getAGeometryObject(b2, s2).getGeometry()) ? 0 : 1;
        }
        return c;
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        return registry.getClassIdentifier(this.getClass(), 1L);
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        return INSTANCE;
    }
}

