/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.job.profiling;

import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.hyracks.api.io.IWritable;
import org.apache.hyracks.api.job.profiling.IndexStats;
import org.apache.hyracks.api.job.profiling.NoOpOperatorStats;
import org.apache.hyracks.api.job.profiling.OperatorStats;
import org.apache.hyracks.api.job.profiling.counters.ICounter;

public interface IOperatorStats
extends IWritable,
Serializable {
    public String getName();

    public ICounter getTupleCounter();

    public ICounter getTimeCounter();

    public ICounter getPageReads();

    public ICounter coldReadCounter();

    public ICounter getAverageTupleSz();

    public ICounter getMaxTupleSz();

    public ICounter getMinTupleSz();

    public ICounter getInputTupleCounter();

    public ICounter getLevel();

    public ICounter getBytesRead();

    public ICounter getBytesWritten();

    public String getOperatorId();

    public void updateIndexesStats(Map<String, IndexStats> var1);

    public Map<String, IndexStats> getIndexesStats();

    public void updateFrom(IOperatorStats var1);

    public static IOperatorStats create(DataInput input) throws IOException {
        String name = input.readUTF();
        if ("NoOp".equals(name)) {
            return NoOpOperatorStats.INSTANCE;
        }
        String operatorId = input.readUTF();
        OperatorStats operatorStats = new OperatorStats(name, operatorId);
        operatorStats.readFields(input);
        return operatorStats;
    }
}

