/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.UptimeCheckServiceClient;
import com.google.cloud.monitoring.v3.stub.GrpcUptimeCheckServiceStub;
import com.google.cloud.monitoring.v3.stub.UptimeCheckServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.CreateUptimeCheckConfigRequest;
import com.google.monitoring.v3.DeleteUptimeCheckConfigRequest;
import com.google.monitoring.v3.GetUptimeCheckConfigRequest;
import com.google.monitoring.v3.ListUptimeCheckConfigsRequest;
import com.google.monitoring.v3.ListUptimeCheckConfigsResponse;
import com.google.monitoring.v3.ListUptimeCheckIpsRequest;
import com.google.monitoring.v3.ListUptimeCheckIpsResponse;
import com.google.monitoring.v3.UpdateUptimeCheckConfigRequest;
import com.google.monitoring.v3.UptimeCheckConfig;
import com.google.monitoring.v3.UptimeCheckIp;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class UptimeCheckServiceStubSettings
extends StubSettings<UptimeCheckServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/monitoring").add((Object)"https://www.googleapis.com/auth/monitoring.read").add((Object)"https://www.googleapis.com/auth/monitoring.write").build();
    private final PagedCallSettings<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckServiceClient.ListUptimeCheckConfigsPagedResponse> listUptimeCheckConfigsSettings;
    private final UnaryCallSettings<GetUptimeCheckConfigRequest, UptimeCheckConfig> getUptimeCheckConfigSettings;
    private final UnaryCallSettings<CreateUptimeCheckConfigRequest, UptimeCheckConfig> createUptimeCheckConfigSettings;
    private final UnaryCallSettings<UpdateUptimeCheckConfigRequest, UptimeCheckConfig> updateUptimeCheckConfigSettings;
    private final UnaryCallSettings<DeleteUptimeCheckConfigRequest, Empty> deleteUptimeCheckConfigSettings;
    private final PagedCallSettings<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckServiceClient.ListUptimeCheckIpsPagedResponse> listUptimeCheckIpsSettings;
    private static final PagedListDescriptor<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckConfig> LIST_UPTIME_CHECK_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListUptimeCheckConfigsRequest injectToken(ListUptimeCheckConfigsRequest payload, String token) {
            return ListUptimeCheckConfigsRequest.newBuilder((ListUptimeCheckConfigsRequest)payload).setPageToken(token).build();
        }

        public ListUptimeCheckConfigsRequest injectPageSize(ListUptimeCheckConfigsRequest payload, int pageSize) {
            return ListUptimeCheckConfigsRequest.newBuilder((ListUptimeCheckConfigsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListUptimeCheckConfigsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListUptimeCheckConfigsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<UptimeCheckConfig> extractResources(ListUptimeCheckConfigsResponse payload) {
            return payload.getUptimeCheckConfigsList() != null ? payload.getUptimeCheckConfigsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckIp> LIST_UPTIME_CHECK_IPS_PAGE_STR_DESC = new PagedListDescriptor<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckIp>(){

        public String emptyToken() {
            return "";
        }

        public ListUptimeCheckIpsRequest injectToken(ListUptimeCheckIpsRequest payload, String token) {
            return ListUptimeCheckIpsRequest.newBuilder((ListUptimeCheckIpsRequest)payload).setPageToken(token).build();
        }

        public ListUptimeCheckIpsRequest injectPageSize(ListUptimeCheckIpsRequest payload, int pageSize) {
            return ListUptimeCheckIpsRequest.newBuilder((ListUptimeCheckIpsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListUptimeCheckIpsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListUptimeCheckIpsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<UptimeCheckIp> extractResources(ListUptimeCheckIpsResponse payload) {
            return payload.getUptimeCheckIpsList() != null ? payload.getUptimeCheckIpsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckServiceClient.ListUptimeCheckConfigsPagedResponse> LIST_UPTIME_CHECK_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckServiceClient.ListUptimeCheckConfigsPagedResponse>(){

        public ApiFuture<UptimeCheckServiceClient.ListUptimeCheckConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse> callable, ListUptimeCheckConfigsRequest request, ApiCallContext context, ApiFuture<ListUptimeCheckConfigsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_UPTIME_CHECK_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return UptimeCheckServiceClient.ListUptimeCheckConfigsPagedResponse.createAsync((PageContext<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckConfig>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckServiceClient.ListUptimeCheckIpsPagedResponse> LIST_UPTIME_CHECK_IPS_PAGE_STR_FACT = new PagedListResponseFactory<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckServiceClient.ListUptimeCheckIpsPagedResponse>(){

        public ApiFuture<UptimeCheckServiceClient.ListUptimeCheckIpsPagedResponse> getFuturePagedResponse(UnaryCallable<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse> callable, ListUptimeCheckIpsRequest request, ApiCallContext context, ApiFuture<ListUptimeCheckIpsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_UPTIME_CHECK_IPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return UptimeCheckServiceClient.ListUptimeCheckIpsPagedResponse.createAsync((PageContext<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckIp>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckServiceClient.ListUptimeCheckConfigsPagedResponse> listUptimeCheckConfigsSettings() {
        return this.listUptimeCheckConfigsSettings;
    }

    public UnaryCallSettings<GetUptimeCheckConfigRequest, UptimeCheckConfig> getUptimeCheckConfigSettings() {
        return this.getUptimeCheckConfigSettings;
    }

    public UnaryCallSettings<CreateUptimeCheckConfigRequest, UptimeCheckConfig> createUptimeCheckConfigSettings() {
        return this.createUptimeCheckConfigSettings;
    }

    public UnaryCallSettings<UpdateUptimeCheckConfigRequest, UptimeCheckConfig> updateUptimeCheckConfigSettings() {
        return this.updateUptimeCheckConfigSettings;
    }

    public UnaryCallSettings<DeleteUptimeCheckConfigRequest, Empty> deleteUptimeCheckConfigSettings() {
        return this.deleteUptimeCheckConfigSettings;
    }

    public PagedCallSettings<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckServiceClient.ListUptimeCheckIpsPagedResponse> listUptimeCheckIpsSettings() {
        return this.listUptimeCheckIpsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public UptimeCheckServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcUptimeCheckServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "monitoring.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return UptimeCheckServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(UptimeCheckServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected UptimeCheckServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listUptimeCheckConfigsSettings = settingsBuilder.listUptimeCheckConfigsSettings().build();
        this.getUptimeCheckConfigSettings = settingsBuilder.getUptimeCheckConfigSettings().build();
        this.createUptimeCheckConfigSettings = settingsBuilder.createUptimeCheckConfigSettings().build();
        this.updateUptimeCheckConfigSettings = settingsBuilder.updateUptimeCheckConfigSettings().build();
        this.deleteUptimeCheckConfigSettings = settingsBuilder.deleteUptimeCheckConfigSettings().build();
        this.listUptimeCheckIpsSettings = settingsBuilder.listUptimeCheckIpsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<UptimeCheckServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckServiceClient.ListUptimeCheckConfigsPagedResponse> listUptimeCheckConfigsSettings;
        private final UnaryCallSettings.Builder<GetUptimeCheckConfigRequest, UptimeCheckConfig> getUptimeCheckConfigSettings;
        private final UnaryCallSettings.Builder<CreateUptimeCheckConfigRequest, UptimeCheckConfig> createUptimeCheckConfigSettings;
        private final UnaryCallSettings.Builder<UpdateUptimeCheckConfigRequest, UptimeCheckConfig> updateUptimeCheckConfigSettings;
        private final UnaryCallSettings.Builder<DeleteUptimeCheckConfigRequest, Empty> deleteUptimeCheckConfigSettings;
        private final PagedCallSettings.Builder<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckServiceClient.ListUptimeCheckIpsPagedResponse> listUptimeCheckIpsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listUptimeCheckConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_UPTIME_CHECK_CONFIGS_PAGE_STR_FACT);
            this.getUptimeCheckConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createUptimeCheckConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateUptimeCheckConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteUptimeCheckConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listUptimeCheckIpsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_UPTIME_CHECK_IPS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listUptimeCheckConfigsSettings, this.getUptimeCheckConfigSettings, this.createUptimeCheckConfigSettings, this.updateUptimeCheckConfigSettings, this.deleteUptimeCheckConfigSettings, this.listUptimeCheckIpsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(UptimeCheckServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)UptimeCheckServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)UptimeCheckServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(UptimeCheckServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listUptimeCheckConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getUptimeCheckConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createUptimeCheckConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateUptimeCheckConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteUptimeCheckConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listUptimeCheckIpsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(UptimeCheckServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listUptimeCheckConfigsSettings = settings.listUptimeCheckConfigsSettings.toBuilder();
            this.getUptimeCheckConfigSettings = settings.getUptimeCheckConfigSettings.toBuilder();
            this.createUptimeCheckConfigSettings = settings.createUptimeCheckConfigSettings.toBuilder();
            this.updateUptimeCheckConfigSettings = settings.updateUptimeCheckConfigSettings.toBuilder();
            this.deleteUptimeCheckConfigSettings = settings.deleteUptimeCheckConfigSettings.toBuilder();
            this.listUptimeCheckIpsSettings = settings.listUptimeCheckIpsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listUptimeCheckConfigsSettings, this.getUptimeCheckConfigSettings, this.createUptimeCheckConfigSettings, this.updateUptimeCheckConfigSettings, this.deleteUptimeCheckConfigSettings, this.listUptimeCheckIpsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse, UptimeCheckServiceClient.ListUptimeCheckConfigsPagedResponse> listUptimeCheckConfigsSettings() {
            return this.listUptimeCheckConfigsSettings;
        }

        public UnaryCallSettings.Builder<GetUptimeCheckConfigRequest, UptimeCheckConfig> getUptimeCheckConfigSettings() {
            return this.getUptimeCheckConfigSettings;
        }

        public UnaryCallSettings.Builder<CreateUptimeCheckConfigRequest, UptimeCheckConfig> createUptimeCheckConfigSettings() {
            return this.createUptimeCheckConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateUptimeCheckConfigRequest, UptimeCheckConfig> updateUptimeCheckConfigSettings() {
            return this.updateUptimeCheckConfigSettings;
        }

        public UnaryCallSettings.Builder<DeleteUptimeCheckConfigRequest, Empty> deleteUptimeCheckConfigSettings() {
            return this.deleteUptimeCheckConfigSettings;
        }

        public PagedCallSettings.Builder<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse, UptimeCheckServiceClient.ListUptimeCheckIpsPagedResponse> listUptimeCheckIpsSettings() {
            return this.listUptimeCheckIpsSettings;
        }

        public UptimeCheckServiceStubSettings build() throws IOException {
            return new UptimeCheckServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

