/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.tuples;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.INullIntrospector;
import org.apache.hyracks.storage.am.common.util.BitOperationUtils;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMTreeTupleWriter;
import org.apache.hyracks.storage.am.lsm.rtree.tuples.LSMRTreeTupleReference;
import org.apache.hyracks.storage.am.rtree.tuples.RTreeTypeAwareTupleWriter;

public class LSMRTreeTupleWriter
extends RTreeTypeAwareTupleWriter
implements ILSMTreeTupleWriter {
    private boolean isAntimatter;

    public LSMRTreeTupleWriter(ITypeTraits[] typeTraits, boolean isAntimatter, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector) {
        super(typeTraits, nullTypeTraits, nullIntrospector);
        this.isAntimatter = isAntimatter;
    }

    public LSMRTreeTupleReference createTupleReference() {
        return new LSMRTreeTupleReference(this.typeTraits, this.nullTypeTraits);
    }

    public int bytesRequired(ITupleReference tuple) {
        return super.bytesRequired(tuple);
    }

    public int writeTuple(ITupleReference tuple, byte[] targetBuf, int targetOff) {
        int bytesWritten = super.writeTuple(tuple, targetBuf, targetOff);
        if (this.isAntimatter) {
            BitOperationUtils.setBit((byte[])targetBuf, (int)targetOff, (byte)7);
        }
        return bytesWritten;
    }

    protected int getNullFlagsBytes(int numFields) {
        return BitOperationUtils.getFlagBytes((int)(numFields + 1));
    }

    protected int getNullFlagsBytes(ITupleReference tuple) {
        return BitOperationUtils.getFlagBytes((int)(tuple.getFieldCount() + 1));
    }

    public void setAntimatter(boolean isAntimatter) {
        this.isAntimatter = isAntimatter;
    }

    protected int getAdjustedFieldIdx(int fieldIdx) {
        return fieldIdx + 1;
    }
}

