/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.collections;

import org.apache.asterix.runtime.aggregates.std.AbstractAggregateFunction;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class LastElementEvalFactory
implements IAggregateEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private final IScalarEvaluatorFactory[] args;
    private final SourceLocation sourceLoc;

    LastElementEvalFactory(IScalarEvaluatorFactory[] args, SourceLocation sourceLoc) {
        this.args = args;
        this.sourceLoc = sourceLoc;
    }

    public IAggregateEvaluator createAggregateEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
        return new AbstractAggregateFunction(this.sourceLoc){
            private ArrayBackedValueStorage outputVal;
            private IPointable inputVal;
            private IScalarEvaluator eval;
            private boolean empty;
            {
                super(sourceLoc);
                this.outputVal = new ArrayBackedValueStorage();
                this.inputVal = new VoidPointable();
                this.eval = LastElementEvalFactory.this.args[0].createScalarEvaluator(ctx);
            }

            public void init() {
                this.empty = true;
            }

            public void step(IFrameTupleReference tuple) throws HyracksDataException {
                this.eval.evaluate(tuple, this.inputVal);
                this.outputVal.assign((IValueReference)this.inputVal);
                this.empty = false;
            }

            public void finish(IPointable result) {
                if (this.empty) {
                    PointableHelper.setNull(result);
                } else {
                    result.set((IValueReference)this.outputVal);
                }
            }

            public void finishPartial(IPointable result) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

