/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.accessors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.dataflow.data.nontagged.serde.ADurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AYearMonthDurationSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.UTF8StringCharacterIterator;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class TemporalYearAccessor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private static final FunctionIdentifier FID = BuiltinFunctions.ACCESSOR_TEMPORAL_YEAR;
    public static final IFunctionDescriptorFactory FACTORY = TemporalYearAccessor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IPointable argPtr = new VoidPointable();
                    private final IScalarEvaluator eval;
                    private final GregorianCalendarSystem calSystem;
                    private final UTF8StringPointable strExprPtr;
                    private final UTF8StringCharacterIterator strIter;
                    private final ISerializerDeserializer<AInt64> intSerde;
                    private final AMutableInt64 aMutableInt64;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.calSystem = GregorianCalendarSystem.getInstance();
                        this.strExprPtr = new UTF8StringPointable();
                        this.strIter = new UTF8StringCharacterIterator();
                        this.intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                        this.aMutableInt64 = new AMutableInt64(0L);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.eval.evaluate(tuple, this.argPtr);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.argPtr)) {
                            return;
                        }
                        byte[] bytes = this.argPtr.getByteArray();
                        int startOffset = this.argPtr.getStartOffset();
                        int len = this.argPtr.getLength();
                        this.resultStorage.reset();
                        try {
                            if (bytes[startOffset] == ATypeTag.SERIALIZED_DURATION_TYPE_TAG) {
                                this.aMutableInt64.setValue((long)this.calSystem.getDurationYear(ADurationSerializerDeserializer.getYearMonth((byte[])bytes, (int)(startOffset + 1))));
                                this.intSerde.serialize((Object)this.aMutableInt64, this.out);
                                result.set((IValueReference)this.resultStorage);
                                return;
                            }
                            if (bytes[startOffset] == ATypeTag.SERIALIZED_YEAR_MONTH_DURATION_TYPE_TAG) {
                                this.aMutableInt64.setValue((long)this.calSystem.getDurationYear(AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes, (int)(startOffset + 1))));
                                this.intSerde.serialize((Object)this.aMutableInt64, this.out);
                                result.set((IValueReference)this.resultStorage);
                                return;
                            }
                            long chrononTimeInMs = 0L;
                            if (bytes[startOffset] == ATypeTag.SERIALIZED_DATE_TYPE_TAG) {
                                chrononTimeInMs = (long)AInt32SerializerDeserializer.getInt((byte[])bytes, (int)(startOffset + 1)) * 86400000L;
                            } else if (bytes[startOffset] == ATypeTag.SERIALIZED_DATETIME_TYPE_TAG) {
                                chrononTimeInMs = AInt64SerializerDeserializer.getLong((byte[])bytes, (int)(startOffset + 1));
                            } else {
                                if (bytes[startOffset] == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                    this.strExprPtr.set(bytes, startOffset + 1, len - 1);
                                    this.strIter.reset(this.strExprPtr);
                                    char firstChar = this.strIter.next();
                                    int year = firstChar == '-' ? -1 * ((this.strIter.next() - 48) * 1000 + (this.strIter.next() - 48) * 100 + (this.strIter.next() - 48) * 10 + (this.strIter.next() - 48)) : (firstChar - 48) * 1000 + (this.strIter.next() - 48) * 100 + (this.strIter.next() - 48) * 10 + (this.strIter.next() - 48);
                                    this.aMutableInt64.setValue((long)year);
                                    this.intSerde.serialize((Object)this.aMutableInt64, this.out);
                                    result.set((IValueReference)this.resultStorage);
                                    return;
                                }
                                throw new TypeMismatchException(TemporalYearAccessor.this.sourceLoc, TemporalYearAccessor.this.getIdentifier(), 0, bytes[startOffset], ATypeTag.SERIALIZED_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_YEAR_MONTH_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            }
                            int year = this.calSystem.getYear(chrononTimeInMs);
                            this.aMutableInt64.setValue((long)year);
                            this.intSerde.serialize((Object)this.aMutableInt64, this.out);
                            result.set((IValueReference)this.resultStorage);
                        }
                        catch (IOException e) {
                            throw HyracksDataException.create((Throwable)e);
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return FID;
    }
}

