/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.base.AMutableBinary;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.constructors.AbstractBinaryConstructorEvaluator;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.util.bytes.HexParser;

@MissingNullInOutFunction
public class ABinaryHexStringConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = ABinaryHexStringConstructorDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new AbstractBinaryConstructorEvaluator(ctx, args[0].createScalarEvaluator(ctx), ABinaryHexStringConstructorDescriptor.this.sourceLoc){
                    private final HexParser parser;
                    {
                        this.parser = new HexParser();
                    }

                    @Override
                    protected boolean parseBinary(UTF8StringPointable textPtr, AMutableBinary result) {
                        try {
                            this.parser.generateByteArrayFromHexString(textPtr.getByteArray(), textPtr.getCharStartOffset(), textPtr.getUTF8Length());
                        }
                        catch (IllegalArgumentException e) {
                            return false;
                        }
                        result.setValue(this.parser.getByteArray(), 0, this.parser.getLength());
                        return true;
                    }

                    @Override
                    protected FunctionIdentifier getIdentifier() {
                        return ABinaryHexStringConstructorDescriptor.this.getIdentifier();
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.BINARY_HEX_CONSTRUCTOR;
    }
}

