/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import org.apache.asterix.dataflow.data.nontagged.serde.ADayTimeDurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AYearMonthDurationSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADuration;
import org.apache.asterix.om.base.AMutableDuration;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.temporal.ADurationParserFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.constructors.AbstractConstructorEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

public abstract class AbstractDurationConstructorEvaluator
extends AbstractConstructorEvaluator {
    private final AMutableDuration aDuration = new AMutableDuration(0, 0L);
    private final ISerializerDeserializer<ADuration> durationSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADURATION);
    private final UTF8StringPointable utf8Ptr = new UTF8StringPointable();

    protected AbstractDurationConstructorEvaluator(IEvaluatorContext ctx, IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        super(ctx, inputEval, sourceLoc);
    }

    @Override
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        byte[] bytes = this.inputArg.getByteArray();
        int startOffset = this.inputArg.getStartOffset();
        int len = this.inputArg.getLength();
        ATypeTag inputType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset]);
        switch (inputType) {
            case DURATION: {
                result.set((IValueReference)this.inputArg);
                break;
            }
            case YEARMONTHDURATION: {
                int months = AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes, (int)(startOffset + 1));
                this.aDuration.setValue(months, 0L);
                this.resultStorage.reset();
                this.durationSerde.serialize((Object)this.aDuration, this.out);
                result.set((IValueReference)this.resultStorage);
                break;
            }
            case DAYTIMEDURATION: {
                long millis = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes, (int)(startOffset + 1));
                this.aDuration.setValue(0, millis);
                this.resultStorage.reset();
                this.durationSerde.serialize((Object)this.aDuration, this.out);
                result.set((IValueReference)this.resultStorage);
                break;
            }
            case STRING: {
                this.utf8Ptr.set(bytes, startOffset + 1, len - 1);
                if (AbstractDurationConstructorEvaluator.parseDuration(this.utf8Ptr, (ADuration)this.aDuration)) {
                    this.resultStorage.reset();
                    this.durationSerde.serialize((Object)this.aDuration, this.out);
                    result.set((IValueReference)this.resultStorage);
                    break;
                }
                this.handleParseError(this.utf8Ptr, result);
                break;
            }
            default: {
                this.handleUnsupportedType(inputType, result);
            }
        }
    }

    @Override
    protected final BuiltinType getTargetType() {
        return BuiltinType.ADURATION;
    }

    private static boolean parseDuration(UTF8StringPointable textPtr, ADuration result) {
        try {
            ADurationParserFactory.parseDuration((byte[])textPtr.getByteArray(), (int)textPtr.getCharStartOffset(), (int)textPtr.getUTF8Length(), (IAObject)result, (ADurationParserFactory.ADurationParseOption)ADurationParserFactory.ADurationParseOption.All);
            return true;
        }
        catch (HyracksDataException e) {
            return false;
        }
    }
}

