/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.time.zone.ZoneRules;
import java.util.TimeZone;
import org.apache.asterix.om.base.temporal.DateTimeFormatUtils;
import org.apache.asterix.runtime.evaluators.functions.StringEvaluatorUtils;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;

final class TimezoneHelper {
    private final SourceLocation srcLoc;
    private final FunctionIdentifier funID;
    private final ByteArrayAccessibleOutputStream lastTimezoneIdStorage = new ByteArrayAccessibleOutputStream();
    private final UTF8StringPointable lastTimezoneIdPtr = new UTF8StringPointable();
    private ZoneRules lastTimezoneRules;

    TimezoneHelper(SourceLocation srcLoc, FunctionIdentifier funID) {
        this.srcLoc = srcLoc;
        this.funID = funID;
    }

    public ZoneRules parseTimeZone(UTF8StringPointable timezoneIdPtr) throws InvalidDataFormatException {
        boolean newTimeZoneId;
        boolean bl = newTimeZoneId = this.lastTimezoneRules == null || this.lastTimezoneIdPtr.compareTo((IPointable)timezoneIdPtr) != 0;
        if (newTimeZoneId) {
            TimeZone tz = DateTimeFormatUtils.findTimeZone((byte[])timezoneIdPtr.getByteArray(), (int)timezoneIdPtr.getCharStartOffset(), (int)timezoneIdPtr.getUTF8Length());
            if (tz == null) {
                throw new InvalidDataFormatException(this.srcLoc, this.funID, "timezone");
            }
            this.lastTimezoneRules = tz.toZoneId().getRules();
            StringEvaluatorUtils.copyResetUTF8Pointable(timezoneIdPtr, this.lastTimezoneIdStorage, this.lastTimezoneIdPtr);
        }
        return this.lastTimezoneRules;
    }
}

