/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.cbo;

import org.apache.asterix.optimizer.cost.ICost;
import org.apache.asterix.optimizer.rules.cbo.JoinEnum;
import org.apache.asterix.optimizer.rules.cbo.JoinNode;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.HashJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;

public class PlanNode {
    public static int NO_PLAN = -1;
    private final JoinEnum joinEnum;
    int allPlansIndex;
    int[] planIndexes;
    int[] jnIndexes;
    JoinNode jn;
    String datasetName;
    ICost opCost;
    ICost totalCost;
    ICost leftExchangeCost;
    ICost rightExchangeCost;
    JoinMethod joinOp;
    boolean indexHint;
    IExpressionAnnotation joinHint;
    HashJoinExpressionAnnotation.BuildSide side;
    ScanMethod scanOp;
    ILogicalExpression joinExpr;
    DataSourceScanOperator correspondingDataSourceScanOp;
    EmptyTupleSourceOperator correspondingEmptyTupleSourceOp;

    public PlanNode(int planIndex, JoinEnum joinE) {
        this.allPlansIndex = planIndex;
        this.joinEnum = joinE;
        this.planIndexes = new int[2];
        this.jnIndexes = new int[2];
    }

    public int getIndex() {
        return this.allPlansIndex;
    }

    public int[] getPlanIndexes() {
        return this.planIndexes;
    }

    public int getLeftPlanIndex() {
        return this.planIndexes[0];
    }

    public PlanNode getLeftPlanNode() {
        if (this.planIndexes[0] == NO_PLAN) {
            return null;
        }
        return this.joinEnum.allPlans.get(this.planIndexes[0]);
    }

    public PlanNode getRightPlanNode() {
        if (this.planIndexes[1] == NO_PLAN) {
            return null;
        }
        return this.joinEnum.allPlans.get(this.planIndexes[1]);
    }

    public JoinNode getJoinNode() {
        return this.jn;
    }

    public void setJoinNode(JoinNode jn) {
        this.jn = jn;
    }

    public int getRightPlanIndex() {
        return this.planIndexes[1];
    }

    public void setRightPlanIndex(int index) {
        this.planIndexes[1] = index;
    }

    public int getLeftJoinIndex() {
        return this.jnIndexes[0];
    }

    public void setLeftPlanIndex(int index) {
        this.planIndexes[0] = index;
    }

    public void setLeftJoinIndex(int index) {
        this.jnIndexes[0] = index;
    }

    public void setRightJoinIndex(int index) {
        this.jnIndexes[1] = index;
    }

    public int getRightJoinIndex() {
        return this.jnIndexes[1];
    }

    public boolean IsScanNode() {
        return this.getLeftPlanIndex() == NO_PLAN && this.getRightPlanIndex() == NO_PLAN;
    }

    public boolean IsJoinNode() {
        return this.getLeftPlanIndex() != NO_PLAN && this.getRightPlanIndex() != NO_PLAN;
    }

    public Pair<String, String> joinMethod() {
        if (this.joinOp == JoinMethod.HYBRID_HASH_JOIN) {
            return new Pair((Object)"HASH JOIN", (Object)"HJ");
        }
        if (this.joinOp == JoinMethod.BROADCAST_HASH_JOIN) {
            return new Pair((Object)"BROADCAST HASH JOIN", (Object)"BHJ");
        }
        if (this.joinOp == JoinMethod.INDEX_NESTED_LOOP_JOIN) {
            return new Pair((Object)"INDEX NESTED LOOPS JOIN", (Object)"INLJ");
        }
        if (this.joinOp == JoinMethod.CARTESIAN_PRODUCT_JOIN) {
            return new Pair((Object)"CARTESIAN PRODUCT JOIN", (Object)"CPJ");
        }
        return new Pair((Object)"", (Object)"");
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String dsName) {
        this.datasetName = dsName;
    }

    public DataSourceScanOperator getDataSourceScanOp() {
        return this.correspondingDataSourceScanOp;
    }

    public EmptyTupleSourceOperator getEmptyTupleSourceOp() {
        return this.correspondingEmptyTupleSourceOp;
    }

    public void setEmptyTupleSourceOp(EmptyTupleSourceOperator emptyTupleSourceOp) {
        this.correspondingEmptyTupleSourceOp = emptyTupleSourceOp;
    }

    public ICost getOpCost() {
        return this.opCost;
    }

    public void setOpCost(ICost cost) {
        this.opCost = cost;
    }

    public double computeOpCost() {
        return this.opCost.computeTotalCost();
    }

    public ICost getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(ICost tc) {
        this.totalCost = tc;
    }

    public ICost getLeftExchangeCost() {
        return this.leftExchangeCost;
    }

    public ICost getRightExchangeCost() {
        return this.rightExchangeCost;
    }

    public double computeTotalCost() {
        return this.totalCost.computeTotalCost();
    }

    public ScanMethod getScanOp() {
        return this.scanOp;
    }

    public void setScanMethod(ScanMethod sm) {
        this.scanOp = sm;
    }

    public JoinMethod getJoinOp() {
        return this.joinOp;
    }

    public ILogicalExpression getJoinExpr() {
        return this.joinExpr;
    }

    public static enum JoinMethod {
        HYBRID_HASH_JOIN,
        BROADCAST_HASH_JOIN,
        INDEX_NESTED_LOOP_JOIN,
        CARTESIAN_PRODUCT_JOIN;

    }

    public static enum ScanMethod {
        INDEX_SCAN,
        TABLE_SCAN;

    }
}

