/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MaintainedThreadNameExecutorService
extends ThreadPoolExecutor {
    private static final ThreadLocal<String> savedName = new ThreadLocal();

    private MaintainedThreadNameExecutorService(ThreadFactory threadFactory) {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return new MaintainedThreadNameExecutorService(threadFactory);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        savedName.set(t.getName());
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        try {
            Thread.currentThread().setName(savedName.get());
        }
        finally {
            savedName.remove();
        }
    }
}

