/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import org.apache.hyracks.api.exceptions.IFormattedException;
import org.apache.hyracks.http.api.IServlet;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractServlet
implements IServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final String[] paths;
    protected final ConcurrentMap<String, Object> ctx;
    protected final int[] servletPathLengths;

    public AbstractServlet(ConcurrentMap<String, Object> ctx, String ... paths) {
        this.paths = paths;
        this.ctx = ctx;
        this.servletPathLengths = new int[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            this.servletPathLengths[i] = path.endsWith("/*") ? path.indexOf("/*") : (path.endsWith("/") ? path.length() - 1 : path.length());
        }
    }

    @Override
    public String[] getPaths() {
        return this.paths;
    }

    @Override
    public ConcurrentMap<String, Object> ctx() {
        return this.ctx;
    }

    @Override
    public void handle(IServletRequest request, IServletResponse response) {
        try {
            HttpMethod method = request.getHttpRequest().method();
            if (HttpMethod.GET.equals((Object)method)) {
                this.get(request, response);
            } else if (HttpMethod.HEAD.equals((Object)method)) {
                this.head(request, response);
            } else if (HttpMethod.POST.equals((Object)method)) {
                this.post(request, response);
            } else if (HttpMethod.PUT.equals((Object)method)) {
                this.put(request, response);
            } else if (HttpMethod.DELETE.equals((Object)method)) {
                this.delete(request, response);
            } else if (HttpMethod.OPTIONS.equals((Object)method)) {
                this.options(request, response);
            } else {
                this.methodNotAllowed(method, response);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Unhandled exception", (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        catch (Throwable th) {
            try {
                LOGGER.log(Level.WARN, "Unhandled throwable", th);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw th;
        }
    }

    protected void sendError(IServletResponse response, HttpResponseStatus status, String message) throws IOException {
        this.sendError(response, "text/plain", status, message);
    }

    protected void sendError(IServletResponse response, String contentType, HttpResponseStatus status, String message) throws IOException {
        response.setStatus(status);
        HttpUtil.setContentType(response, contentType, StandardCharsets.UTF_8);
        if (message != null) {
            response.writer().println(message);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("sendError: status={}, message={}", (Object)status, (Object)message);
        }
    }

    protected void sendError(IServletResponse response, HttpResponseStatus status, IFormattedException ex) throws IOException {
        this.sendError(response, status, ex != null ? ex.getMessage() : null);
    }

    protected void sendError(IServletResponse response, HttpResponseStatus status) throws IOException {
        this.sendError(response, status, status.reasonPhrase());
    }

    protected void methodNotAllowed(HttpMethod method, IServletResponse response) throws IOException {
        this.sendError(response, HttpResponseStatus.METHOD_NOT_ALLOWED, "Method " + method + " not allowed for the requested resource.");
    }

    protected void get(IServletRequest request, IServletResponse response) throws Exception {
        this.methodNotAllowed(HttpMethod.GET, response);
    }

    protected void head(IServletRequest request, IServletResponse response) throws Exception {
        this.methodNotAllowed(HttpMethod.HEAD, response);
    }

    protected void post(IServletRequest request, IServletResponse response) throws Exception {
        this.methodNotAllowed(HttpMethod.POST, response);
    }

    protected void put(IServletRequest request, IServletResponse response) throws Exception {
        this.methodNotAllowed(HttpMethod.PUT, response);
    }

    protected void delete(IServletRequest request, IServletResponse response) throws Exception {
        this.methodNotAllowed(HttpMethod.DELETE, response);
    }

    protected void options(IServletRequest request, IServletResponse response) throws Exception {
        this.methodNotAllowed(HttpMethod.OPTIONS, response);
    }

    public String host(IServletRequest request) {
        return request.getHttpRequest().headers().get((CharSequence)HttpHeaderNames.HOST);
    }

    public String localPath(IServletRequest request) {
        String uri = request.getHttpRequest().uri();
        int queryStart = uri.indexOf(63);
        return queryStart == -1 ? uri.substring(this.servletLength(uri)) : uri.substring(this.servletLength(uri), queryStart);
    }

    public String servletPath(IServletRequest request) {
        String uri = request.getHttpRequest().uri();
        return uri.substring(0, this.servletLength(uri));
    }

    protected int servletLength(String uri) {
        int trim = -1;
        if (this.paths.length > 1) {
            for (int i = 0; i < this.paths.length; ++i) {
                String path;
                int wildCardIdx = this.paths[i].indexOf("/*");
                String string = path = wildCardIdx >= 0 ? this.paths[i].substring(0, wildCardIdx) : this.paths[i];
                if (uri.indexOf(path) != 0) continue;
                trim = this.servletPathLengths[i];
                break;
            }
        } else {
            trim = this.servletPathLengths[0];
        }
        return trim;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.paths);
    }

    @Override
    public boolean ignoresQueryParameters(HttpMethod method) {
        return false;
    }

    static {
        OBJECT_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        OBJECT_MAPPER.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        OBJECT_MAPPER.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }
}

