/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import org.apache.hyracks.http.server.CLFLogger;
import org.apache.hyracks.http.server.HttpRequestAggregator;
import org.apache.hyracks.http.server.HttpRequestCapacityController;
import org.apache.hyracks.http.server.HttpServer;
import org.apache.hyracks.http.server.HttpServerConfig;

public class HttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final HttpServer server;
    private final int maxRequestSize;
    private final int maxRequestInitialLineLength;
    private final int maxRequestHeaderSize;
    private final int maxRequestChunkSize;
    private final int maxResponseChunkSize;

    public HttpServerInitializer(HttpServer server) {
        this.server = server;
        HttpServerConfig config = server.getConfig();
        this.maxRequestSize = config.getMaxRequestSize();
        this.maxRequestInitialLineLength = config.getMaxRequestInitialLineLength();
        this.maxRequestHeaderSize = config.getMaxRequestHeaderSize();
        this.maxRequestChunkSize = config.getMaxRequestChunkSize();
        this.maxResponseChunkSize = config.getMaxResponseChunkSize();
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        p.addLast(new ChannelHandler[]{new HttpRequestCapacityController(this.server)});
        p.addLast(new ChannelHandler[]{new HttpRequestDecoder(this.maxRequestInitialLineLength, this.maxRequestHeaderSize, this.maxRequestChunkSize)});
        p.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        p.addLast(new ChannelHandler[]{this.getCLFLogger()});
        p.addLast(new ChannelHandler[]{new HttpRequestAggregator(this.maxRequestSize)});
        p.addLast(new ChannelHandler[]{this.server.createHttpHandler(this.maxResponseChunkSize)});
    }

    protected CLFLogger getCLFLogger() {
        return new CLFLogger();
    }
}

