/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.hyracks.api.compression.ICompressorDecompressor;
import org.apache.hyracks.api.compression.ICompressorDecompressorFactory;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.compression.NoOpCompressorDecompressor;
import org.apache.hyracks.storage.common.compression.NoOpCompressorDecompressorFactory;
import org.apache.hyracks.storage.common.compression.file.CompressedFileReference;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public abstract class AbstractLSMIndexFileManager
implements ILSMIndexFileManager {
    public static final String DELIMITER = "_";
    public static final String BTREE_SUFFIX = "b";
    public static final String RTREE_SUFFIX = "r";
    public static final String BLOOM_FILTER_SUFFIX = "f";
    public static final String DELETE_TREE_SUFFIX = "d";
    public static final String LAF_SUFFIX = ".dic";
    public static final String TXN_PREFIX = ".T";
    public static final long UNINITIALIZED_COMPONENT_SEQ = -1L;
    public static final FilenameFilter COMPONENT_FILES_FILTER = (dir, name) -> !name.startsWith(".");
    protected static final FilenameFilter txnFileNameFilter = (dir, name) -> name.startsWith(TXN_PREFIX);
    protected static FilenameFilter bloomFilterFilter = (dir, name) -> !name.startsWith(".") && name.endsWith(BLOOM_FILTER_SUFFIX);
    protected static final Comparator<String> cmp = new FileNameComparator();
    private static final FilenameFilter dummyFilter = (dir, name) -> true;
    protected final IIOManager ioManager;
    protected final FileReference baseDir;
    protected final Comparator<IndexComponentFileReference> recencyCmp = new RecencyComparator();
    protected final TreeIndexFactory<? extends ITreeIndex> treeFactory;
    private long lastUsedComponentSeq = -1L;
    private final ICompressorDecompressorFactory compressorDecompressorFactory;

    public AbstractLSMIndexFileManager(IIOManager ioManager, FileReference file, TreeIndexFactory<? extends ITreeIndex> treeFactory) {
        this(ioManager, file, treeFactory, NoOpCompressorDecompressorFactory.INSTANCE);
    }

    public AbstractLSMIndexFileManager(IIOManager ioManager, FileReference file, TreeIndexFactory<? extends ITreeIndex> treeFactory, ICompressorDecompressorFactory compressorDecompressorFactory) {
        this.ioManager = ioManager;
        this.baseDir = file;
        this.treeFactory = treeFactory;
        this.compressorDecompressorFactory = compressorDecompressorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TreeIndexState isValidTreeIndex(ITreeIndex treeIndex) throws HyracksDataException {
        IBufferCache bufferCache = treeIndex.getBufferCache();
        treeIndex.activate();
        try {
            ICachedPage page;
            block13: {
                ITreeIndexMetadataFrame metadataFrame;
                block12: {
                    TreeIndexState treeIndexState;
                    int metadataPage = treeIndex.getPageManager().getMetadataPageId();
                    if (metadataPage < 0) {
                        TreeIndexState treeIndexState2 = TreeIndexState.INVALID;
                        return treeIndexState2;
                    }
                    metadataFrame = treeIndex.getPageManager().createMetadataFrame();
                    page = bufferCache.pin(BufferedFileHandle.getDiskPageId((int)treeIndex.getFileId(), (int)metadataPage), false);
                    page.acquireReadLatch();
                    try {
                        metadataFrame.setPage(page);
                        if (metadataFrame.isValid()) break block12;
                        treeIndexState = TreeIndexState.INVALID;
                    }
                    catch (Throwable throwable) {
                        page.releaseReadLatch();
                        bufferCache.unpin(page);
                        throw throwable;
                    }
                    page.releaseReadLatch();
                    bufferCache.unpin(page);
                    return treeIndexState;
                }
                if (metadataFrame.getVersion() == 7) break block13;
                TreeIndexState treeIndexState = TreeIndexState.VERSION_MISMATCH;
                page.releaseReadLatch();
                bufferCache.unpin(page);
                return treeIndexState;
            }
            TreeIndexState treeIndexState = TreeIndexState.VALID;
            page.releaseReadLatch();
            bufferCache.unpin(page);
            return treeIndexState;
        }
        finally {
            treeIndex.deactivate();
        }
    }

    protected void cleanupAndGetValidFilesInternal(FilenameFilter filter, TreeIndexFactory<? extends ITreeIndex> treeFactory, ArrayList<IndexComponentFileReference> allFiles, IBufferCache bufferCache) throws HyracksDataException {
        String[] files;
        for (String fileName : files = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, filter)) {
            FileReference fileRef = this.getFileReference(fileName);
            if (treeFactory == null) {
                allFiles.add(IndexComponentFileReference.of(fileRef));
                continue;
            }
            TreeIndexState idxState = this.isValidTreeIndex((ITreeIndex)treeFactory.createIndexInstance(fileRef));
            if (idxState == TreeIndexState.VALID) {
                allFiles.add(IndexComponentFileReference.of(fileRef));
                continue;
            }
            if (idxState != TreeIndexState.INVALID) continue;
            bufferCache.deleteFile(fileRef);
        }
    }

    static String[] listDirFiles(FileReference dir, FilenameFilter filter) throws HyracksDataException {
        String[] files = dir.getFile().list(filter);
        if (files == null) {
            if (!dir.getFile().canRead()) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_READ_FILE, (Serializable[])new Serializable[]{dir});
            }
            if (!dir.getFile().exists()) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.FILE_DOES_NOT_EXIST, (Serializable[])new Serializable[]{dir});
            }
            if (!dir.getFile().isDirectory()) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.FILE_IS_NOT_DIRECTORY, (Serializable[])new Serializable[]{dir});
            }
            throw HyracksDataException.create((ErrorCode)ErrorCode.UNIDENTIFIED_IO_ERROR_READING_FILE, (Serializable[])new Serializable[]{dir});
        }
        return files;
    }

    protected void validateFiles(HashSet<String> groundTruth, ArrayList<IndexComponentFileReference> validFiles, FilenameFilter filter, TreeIndexFactory<? extends ITreeIndex> treeFactory, IBufferCache bufferCache) throws HyracksDataException {
        ArrayList<IndexComponentFileReference> tmpAllInvListsFiles = new ArrayList<IndexComponentFileReference>();
        this.cleanupAndGetValidFilesInternal(filter, treeFactory, tmpAllInvListsFiles, bufferCache);
        for (IndexComponentFileReference cmpFileName : tmpAllInvListsFiles) {
            if (groundTruth.contains(cmpFileName.getSequence())) {
                validFiles.add(cmpFileName);
                continue;
            }
            this.delete(bufferCache, cmpFileName.getFileRef());
        }
    }

    @Override
    public void createDirs() throws HyracksDataException {
        if (this.baseDir.getFile().exists()) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_CREATE_EXISTING_INDEX, (Serializable[])new Serializable[0]);
        }
        this.baseDir.getFile().mkdirs();
    }

    @Override
    public void deleteDirs() throws HyracksDataException {
        IoUtil.delete((FileReference)this.baseDir);
    }

    @Override
    public LSMComponentFileReferences getRelFlushFileReference() throws HyracksDataException {
        String sequence = this.getNextComponentSequence(COMPONENT_FILES_FILTER);
        return new LSMComponentFileReferences(this.baseDir.getChild(sequence), null, null);
    }

    @Override
    public LSMComponentFileReferences getRelMergeFileReference(String firstFileName, String lastFileName) {
        String baseName = IndexComponentFileReference.getMergeSequence(firstFileName, lastFileName);
        return new LSMComponentFileReferences(this.baseDir.getChild(baseName), null, null);
    }

    @Override
    public List<LSMComponentFileReferences> cleanupAndGetValidFiles() throws HyracksDataException {
        ArrayList<LSMComponentFileReferences> validFiles = new ArrayList<LSMComponentFileReferences>();
        ArrayList<IndexComponentFileReference> allFiles = new ArrayList<IndexComponentFileReference>();
        this.cleanupAndGetValidFilesInternal(COMPONENT_FILES_FILTER, this.treeFactory, allFiles, this.treeFactory.getBufferCache());
        if (allFiles.isEmpty()) {
            return validFiles;
        }
        if (allFiles.size() == 1) {
            validFiles.add(new LSMComponentFileReferences(allFiles.get(0).getFileRef(), null, null));
            return validFiles;
        }
        Collections.sort(allFiles);
        ArrayList<IndexComponentFileReference> validComparableFiles = new ArrayList<IndexComponentFileReference>();
        IndexComponentFileReference last = allFiles.get(0);
        validComparableFiles.add(last);
        for (int i = 1; i < allFiles.size(); ++i) {
            IndexComponentFileReference current = allFiles.get(i);
            if (current.isMoreRecentThan(last)) {
                validComparableFiles.add(current);
                last = current;
                continue;
            }
            if (current.isWithin(last)) {
                this.delete(this.treeFactory.getBufferCache(), current.getFileRef());
                continue;
            }
            throw HyracksDataException.create((ErrorCode)ErrorCode.FOUND_OVERLAPPING_LSM_FILES, (Serializable[])new Serializable[]{this.baseDir});
        }
        validComparableFiles.sort(this.recencyCmp);
        for (IndexComponentFileReference cmpFileName : validComparableFiles) {
            validFiles.add(new LSMComponentFileReferences(cmpFileName.getFileRef(), null, null));
        }
        return validFiles;
    }

    @Override
    public Comparator<String> getFileNameComparator() {
        return cmp;
    }

    @Override
    public FileReference getBaseDir() {
        return this.baseDir;
    }

    @Override
    public void recoverTransaction() throws HyracksDataException {
        String[] files = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, txnFileNameFilter);
        if (files.length != 0) {
            if (files.length > 1) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.FOUND_MULTIPLE_TRANSACTIONS, (Serializable[])new Serializable[]{this.baseDir});
            }
            IoUtil.delete((FileReference)this.baseDir.getChild(files[0]));
        }
    }

    @Override
    public void deleteTransactionFiles() throws HyracksDataException {
        String[] files = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, txnFileNameFilter);
        if (files.length != 0) {
            String[] componentsFiles;
            if (files.length > 1) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.FOUND_MULTIPLE_TRANSACTIONS, (Serializable[])new Serializable[]{this.baseDir});
            }
            FilenameFilter transactionFilter = AbstractLSMIndexFileManager.createTransactionFilter(files[0], true);
            for (String fileName : componentsFiles = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, transactionFilter)) {
                FileReference file = this.baseDir.getChild(fileName);
                IoUtil.delete((FileReference)file);
            }
            IoUtil.delete((FileReference)this.baseDir.getChild(files[0]));
        }
    }

    @Override
    public LSMComponentFileReferences getNewTransactionFileReference() throws IOException {
        return null;
    }

    @Override
    public LSMComponentFileReferences getTransactionFileReferenceForCommit() throws HyracksDataException {
        return null;
    }

    @Override
    public void initLastUsedSeq(long lastUsedSeq) {
        this.lastUsedComponentSeq = lastUsedSeq;
    }

    private static FilenameFilter createTransactionFilter(String transactionFileName, boolean inclusive) {
        String timeStamp = transactionFileName.substring(transactionFileName.indexOf(TXN_PREFIX) + TXN_PREFIX.length());
        return (dir, name) -> inclusive == name.startsWith(timeStamp);
    }

    protected FilenameFilter getTransactionFileFilter(boolean inclusive) throws HyracksDataException {
        String[] files = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, txnFileNameFilter);
        if (files.length == 0) {
            return dummyFilter;
        }
        return AbstractLSMIndexFileManager.createTransactionFilter(files[0], inclusive);
    }

    protected void delete(IBufferCache bufferCache, FileReference fileRef) throws HyracksDataException {
        bufferCache.deleteFile(fileRef);
    }

    protected FilenameFilter getCompoundFilter(FilenameFilter filter1, FilenameFilter filter2) {
        return (dir, name) -> filter1.accept(dir, name) && filter2.accept(dir, name);
    }

    protected String getNextComponentSequence(FilenameFilter filenameFilter) throws HyracksDataException {
        if (this.lastUsedComponentSeq == -1L) {
            this.lastUsedComponentSeq = this.getOnDiskLastUsedComponentSequence(filenameFilter);
        }
        return IndexComponentFileReference.getFlushSequence(++this.lastUsedComponentSeq);
    }

    protected FileReference getFileReference(String name) {
        ICompressorDecompressor compDecomp = this.compressorDecompressorFactory.createInstance();
        if (compDecomp != NoOpCompressorDecompressor.INSTANCE && this.isCompressible(name)) {
            String path = this.baseDir.getChildPath(name);
            return new CompressedFileReference(this.baseDir.getDeviceHandle(), compDecomp, path, path + LAF_SUFFIX);
        }
        return this.baseDir.getChild(name);
    }

    private boolean isCompressible(String fileName) {
        return !fileName.endsWith(BLOOM_FILTER_SUFFIX) && !fileName.endsWith(DELETE_TREE_SUFFIX);
    }

    private long getOnDiskLastUsedComponentSequence(FilenameFilter filenameFilter) throws HyracksDataException {
        String[] files;
        long maxComponentSeq = -1L;
        for (String fileName : files = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, filenameFilter)) {
            maxComponentSeq = Math.max(maxComponentSeq, IndexComponentFileReference.of(fileName).getSequenceEnd());
        }
        return maxComponentSeq;
    }

    private class RecencyComparator
    implements Comparator<IndexComponentFileReference> {
        private RecencyComparator() {
        }

        @Override
        public int compare(IndexComponentFileReference a, IndexComponentFileReference b) {
            int startCmp = -Long.compare(a.getSequenceStart(), b.getSequenceStart());
            if (startCmp != 0) {
                return startCmp;
            }
            return -Long.compare(a.getSequenceEnd(), b.getSequenceEnd());
        }
    }

    public static enum TreeIndexState {
        INVALID,
        VERSION_MISMATCH,
        VALID;

    }

    private static class FileNameComparator
    implements Comparator<String> {
        private FileNameComparator() {
        }

        @Override
        public int compare(String a, String b) {
            return IndexComponentFileReference.of(b).compareTo(IndexComponentFileReference.of(a));
        }
    }
}

