/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ILSMIndexCursor;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMTreeTupleReference;
import org.apache.hyracks.storage.common.EnforcedIndexCursor;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.MultiComparator;

public abstract class LSMIndexSearchCursor
extends EnforcedIndexCursor
implements ILSMIndexCursor {
    public static final int SWITCH_COMPONENT_CYCLE = 100;
    protected final ILSMIndexOperationContext opCtx;
    protected final boolean returnDeletedTuples;
    protected PriorityQueueElement outputElement;
    protected final ArrayTupleBuilder[] switchComponentTupleBuilders;
    protected final boolean[] switchRequest;
    protected final PriorityQueueElement[] switchedElements;
    protected IIndexCursor[] rangeCursors;
    protected PriorityQueueElement[] pqes;
    protected PriorityQueue<PriorityQueueElement> outputPriorityQueue;
    protected PriorityQueueComparator pqCmp;
    protected MultiComparator cmp;
    protected boolean needPushElementIntoQueue;
    protected boolean includeMutableComponent;
    protected ILSMHarness lsmHarness;
    protected boolean switchPossible = true;
    protected int hasNextCallCount = 0;
    protected List<ILSMComponent> operationalComponents;
    protected final IIndexAccessParameters iap;

    public LSMIndexSearchCursor(ILSMIndexOperationContext opCtx, boolean returnDeletedTuples, IIndexCursorStats stats) {
        this.opCtx = opCtx;
        this.returnDeletedTuples = returnDeletedTuples;
        this.outputElement = null;
        this.needPushElementIntoQueue = false;
        this.switchComponentTupleBuilders = new ArrayTupleBuilder[opCtx.getIndex().getNumberOfAllMemoryComponents()];
        this.switchRequest = new boolean[this.switchComponentTupleBuilders.length];
        this.switchedElements = new PriorityQueueElement[this.switchComponentTupleBuilders.length];
        this.iap = IndexAccessParameters.createNoOpParams((IIndexCursorStats)stats);
    }

    public ILSMIndexOperationContext getOpCtx() {
        return this.opCtx;
    }

    public void initPriorityQueue() throws HyracksDataException {
        int pqInitSize;
        int n = pqInitSize = this.rangeCursors.length > 0 ? this.rangeCursors.length : 1;
        if (this.outputPriorityQueue == null) {
            int i;
            this.outputPriorityQueue = new PriorityQueue<PriorityQueueElement>(pqInitSize, this.pqCmp);
            this.pqes = new PriorityQueueElement[pqInitSize];
            for (i = 0; i < pqInitSize; ++i) {
                this.pqes[i] = new PriorityQueueElement(i);
            }
            for (i = 0; i < this.rangeCursors.length; ++i) {
                this.pushIntoQueueFromCursorAndReplaceThisElement(this.pqes[i]);
            }
        } else {
            this.outputPriorityQueue.clear();
            if (pqInitSize == this.pqes.length) {
                for (int i = 0; i < this.rangeCursors.length; ++i) {
                    this.pqes[i].reset(null);
                    this.pushIntoQueueFromCursorAndReplaceThisElement(this.pqes[i]);
                }
            } else {
                this.pqes = new PriorityQueueElement[pqInitSize];
                for (int i = 0; i < this.rangeCursors.length; ++i) {
                    this.pqes[i] = new PriorityQueueElement(i);
                    this.pushIntoQueueFromCursorAndReplaceThisElement(this.pqes[i]);
                }
            }
        }
    }

    public IIndexCursor getCursor(int cursorIndex) {
        return this.rangeCursors[cursorIndex];
    }

    public void doClose() throws HyracksDataException {
        int i;
        this.hasNextCallCount = 0;
        this.switchPossible = true;
        this.outputElement = null;
        this.needPushElementIntoQueue = false;
        for (i = 0; i < this.switchRequest.length; ++i) {
            this.switchRequest[i] = false;
            this.switchedElements[i] = null;
        }
        try {
            if (this.outputPriorityQueue != null) {
                this.outputPriorityQueue.clear();
            }
            if (this.rangeCursors != null) {
                for (i = 0; i < this.rangeCursors.length; ++i) {
                    this.rangeCursors[i].close();
                }
            }
        }
        finally {
            if (this.lsmHarness != null) {
                this.lsmHarness.endSearch(this.opCtx);
            }
        }
    }

    public boolean doHasNext() throws HyracksDataException {
        ++this.hasNextCallCount;
        this.checkPriorityQueue();
        return !this.outputPriorityQueue.isEmpty();
    }

    public void doNext() throws HyracksDataException {
        this.outputElement = this.outputPriorityQueue.poll();
        this.needPushElementIntoQueue = true;
    }

    public void doDestroy() throws HyracksDataException {
        try {
            if (this.outputPriorityQueue != null) {
                this.outputPriorityQueue.clear();
            }
            if (this.rangeCursors != null) {
                for (int i = 0; i < this.rangeCursors.length; ++i) {
                    if (this.rangeCursors[i] == null) continue;
                    this.rangeCursors[i].destroy();
                }
                this.rangeCursors = null;
            }
        }
        finally {
            if (this.lsmHarness != null) {
                this.lsmHarness.endSearch(this.opCtx);
            }
        }
    }

    public ITupleReference doGetTuple() {
        return this.outputElement.getTuple();
    }

    public ITupleReference getFilterMinTuple() {
        ILSMComponentFilter filter = this.operationalComponents.get(this.outputElement.cursorIndex).getLSMComponentFilter();
        return filter == null ? null : filter.getMinTuple();
    }

    public ITupleReference getFilterMaxTuple() {
        ILSMComponentFilter filter = this.operationalComponents.get(this.outputElement.cursorIndex).getLSMComponentFilter();
        return filter == null ? null : filter.getMaxTuple();
    }

    protected void pushIntoQueueFromCursorAndReplaceThisElement(PriorityQueueElement e) throws HyracksDataException {
        int cursorIndex = e.getCursorIndex();
        if (this.rangeCursors[cursorIndex].hasNext()) {
            this.rangeCursors[cursorIndex].next();
            e.reset(this.rangeCursors[cursorIndex].getTuple());
            this.outputPriorityQueue.offer(e);
            return;
        }
        this.rangeCursors[cursorIndex].close();
        if (cursorIndex == 0) {
            this.includeMutableComponent = false;
        }
    }

    protected boolean isDeleted(PriorityQueueElement checkElement) throws HyracksDataException {
        return ((ILSMTreeTupleReference)checkElement.getTuple()).isAntimatter();
    }

    protected void checkPriorityQueue() throws HyracksDataException {
        while (!this.outputPriorityQueue.isEmpty() || this.needPushElementIntoQueue) {
            if (!this.outputPriorityQueue.isEmpty()) {
                PriorityQueueElement checkElement = this.outputPriorityQueue.peek();
                if (this.outputElement == null) {
                    if (!this.isDeleted(checkElement) || this.returnDeletedTuples) break;
                    this.outputElement = this.outputPriorityQueue.poll();
                    this.needPushElementIntoQueue = true;
                    continue;
                }
                if (this.compare(this.cmp, this.outputElement.getTuple(), checkElement.getTuple()) == 0) {
                    PriorityQueueElement e = this.outputPriorityQueue.poll();
                    this.pushIntoQueueFromCursorAndReplaceThisElement(e);
                    continue;
                }
                if (this.needPushElementIntoQueue) {
                    this.pushIntoQueueFromCursorAndReplaceThisElement(this.outputElement);
                    this.needPushElementIntoQueue = false;
                }
                this.outputElement = null;
                continue;
            }
            this.pushIntoQueueFromCursorAndReplaceThisElement(this.outputElement);
            this.needPushElementIntoQueue = false;
            this.outputElement = null;
        }
    }

    protected void setPriorityQueueComparator() {
        if (this.pqCmp == null || this.cmp != this.pqCmp.getMultiComparator()) {
            this.pqCmp = new PriorityQueueComparator(this.cmp);
        }
    }

    protected int compare(MultiComparator cmp, ITupleReference tupleA, ITupleReference tupleB) throws HyracksDataException {
        return cmp.compare(tupleA, tupleB);
    }

    public boolean getSearchOperationCallbackProceedResult() {
        return false;
    }

    public static class PriorityQueueElement {
        private ITupleReference tuple = null;
        private final int cursorIndex;

        public PriorityQueueElement(int cursorIndex) {
            this.cursorIndex = cursorIndex;
        }

        public ITupleReference getTuple() {
            return this.tuple;
        }

        public int getCursorIndex() {
            return this.cursorIndex;
        }

        public void reset(ITupleReference tuple) {
            this.tuple = tuple;
        }
    }

    public static class PriorityQueueComparator
    implements Comparator<PriorityQueueElement> {
        protected MultiComparator cmp;

        public PriorityQueueComparator(MultiComparator cmp) {
            this.cmp = cmp;
        }

        @Override
        public int compare(PriorityQueueElement elementA, PriorityQueueElement elementB) {
            try {
                int result = this.cmp.compare(elementA.getTuple(), elementB.getTuple());
                if (result != 0) {
                    return result;
                }
            }
            catch (HyracksDataException e) {
                throw new IllegalArgumentException(e);
            }
            if (elementA.getCursorIndex() > elementB.getCursorIndex()) {
                return 1;
            }
            return -1;
        }

        public MultiComparator getMultiComparator() {
            return this.cmp;
        }

        public void setMultiComparator(MultiComparator cmp) {
            this.cmp = cmp;
        }
    }
}

