/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.parser.JSONDataParser;
import org.apache.asterix.external.parser.ParseException;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutablePoint;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.util.bytes.HexParser;

public final class LosslessADMJSONDataParser
extends JSONDataParser {
    private AMutablePoint[] polygonPoints;

    public LosslessADMJSONDataParser(JsonFactory jsonFactory) {
        super(RecordUtil.FULLY_OPEN_RECORD_TYPE, jsonFactory);
    }

    @Override
    protected void serializeNumeric(ATypeTag numericType, DataOutput out) throws IOException {
        super.serializeNumeric(ATypeTag.BIGINT, out);
    }

    @Override
    protected void serializeString(ATypeTag stringVariantType, DataOutput out) throws IOException {
        int textLength;
        int textOffset;
        char[] textChars = this.jsonParser.getTextCharacters();
        ATypeTag typeToUse = LosslessADMJSONDataParser.parseTypeTag(textChars, textOffset = this.jsonParser.getTextOffset(), textLength = this.jsonParser.getTextLength(), this.aInt32);
        if (typeToUse == null) {
            throw new RuntimeDataException(ErrorCode.RECORD_READER_MALFORMED_INPUT_STREAM, new Serializable[0]);
        }
        int parsedLength = this.aInt32.getIntegerValue();
        int nonTaggedTextOffset = textOffset + parsedLength;
        int nonTaggedTextLength = textLength - parsedLength;
        switch (typeToUse) {
            case MISSING: {
                this.missingSerde.serialize((Object)AMissing.MISSING, out);
                break;
            }
            case NULL: {
                this.nullSerde.serialize((Object)ANull.NULL, out);
                break;
            }
            case BOOLEAN: {
                this.parseInt64(textChars, nonTaggedTextOffset, nonTaggedTextLength, this.aInt64);
                this.booleanSerde.serialize((Object)ABoolean.valueOf((this.aInt64.getLongValue() != 0L ? 1 : 0) != 0), out);
                break;
            }
            case TINYINT: {
                this.parseInt64(textChars, nonTaggedTextOffset, nonTaggedTextLength, this.aInt64);
                this.aInt8.setValue((byte)this.aInt64.getLongValue());
                this.int8Serde.serialize((Object)this.aInt8, out);
                break;
            }
            case SMALLINT: {
                this.parseInt64(textChars, nonTaggedTextOffset, nonTaggedTextLength, this.aInt64);
                this.aInt16.setValue((short)this.aInt64.getLongValue());
                this.int16Serde.serialize((Object)this.aInt16, out);
                break;
            }
            case INTEGER: {
                this.parseInt64(textChars, nonTaggedTextOffset, nonTaggedTextLength, this.aInt64);
                this.aInt32.setValue((int)this.aInt64.getLongValue());
                this.int32Serde.serialize((Object)this.aInt32, out);
                break;
            }
            case BIGINT: {
                this.parseInt64(textChars, nonTaggedTextOffset, nonTaggedTextLength, this.aInt64);
                this.int64Serde.serialize((Object)this.aInt64, out);
                break;
            }
            case FLOAT: {
                this.parseInt64(textChars, nonTaggedTextOffset, nonTaggedTextLength, this.aInt64);
                this.aFloat.setValue(Float.intBitsToFloat((int)this.aInt64.getLongValue()));
                this.floatSerde.serialize((Object)this.aFloat, out);
                break;
            }
            case DOUBLE: {
                this.parseInt64(textChars, nonTaggedTextOffset, nonTaggedTextLength, this.aInt64);
                this.aDouble.setValue(Double.longBitsToDouble(this.aInt64.getLongValue()));
                this.doubleSerde.serialize((Object)this.aDouble, out);
                break;
            }
            case TIME: {
                this.parseInt64(textChars, nonTaggedTextOffset, nonTaggedTextLength, this.aInt64);
                this.aTime.setValue((int)this.aInt64.getLongValue());
                timeSerde.serialize((Object)this.aTime, out);
                break;
            }
            case DATE: {
                this.parseInt64(textChars, nonTaggedTextOffset, nonTaggedTextLength, this.aInt64);
                this.aDate.setValue((int)this.aInt64.getLongValue());
                dateSerde.serialize((Object)this.aDate, out);
                break;
            }
            case DATETIME: {
                this.parseInt64(textChars, nonTaggedTextOffset, nonTaggedTextLength, this.aInt64);
                this.aDateTime.setValue(this.aInt64.getLongValue());
                datetimeSerde.serialize((Object)this.aDateTime, out);
                break;
            }
            case YEARMONTHDURATION: {
                this.parseInt64(textChars, nonTaggedTextOffset, nonTaggedTextLength, this.aInt64);
                this.aYearMonthDuration.setMonths((int)this.aInt64.getLongValue());
                yearMonthDurationSerde.serialize((Object)this.aYearMonthDuration, out);
                break;
            }
            case DAYTIMEDURATION: {
                this.parseInt64(textChars, nonTaggedTextOffset, nonTaggedTextLength, this.aInt64);
                this.aDayTimeDuration.setMilliseconds(this.aInt64.getLongValue());
                dayTimeDurationSerde.serialize((Object)this.aDayTimeDuration, out);
                break;
            }
            case DURATION: {
                int delimIdx = this.findDelim(textChars, nonTaggedTextOffset, nonTaggedTextLength, BuiltinType.ADURATION);
                this.parseInt64(textChars, nonTaggedTextOffset, delimIdx - nonTaggedTextOffset, this.aInt64);
                int months = (int)this.aInt64.getLongValue();
                this.parseInt64(textChars, delimIdx + 1, textLength - delimIdx - 1, this.aInt64);
                long millis = this.aInt64.getLongValue();
                this.aDuration.setValue(months, millis);
                durationSerde.serialize((Object)this.aDuration, out);
                break;
            }
            case UUID: {
                this.aUUID.parseUUIDString(textChars, nonTaggedTextOffset, nonTaggedTextLength);
                this.uuidSerde.serialize((Object)this.aUUID, out);
                break;
            }
            case STRING: {
                this.parseString(textChars, nonTaggedTextOffset, nonTaggedTextLength, out);
                break;
            }
            case BINARY: {
                this.parseBase64BinaryString(textChars, nonTaggedTextOffset, nonTaggedTextLength, out);
                break;
            }
            case POINT: {
                int delimIdx = this.findDelim(textChars, nonTaggedTextOffset, nonTaggedTextLength, BuiltinType.APOINT);
                this.parseInt64(textChars, nonTaggedTextOffset, delimIdx - nonTaggedTextOffset, this.aInt64);
                double x = Double.longBitsToDouble(this.aInt64.getLongValue());
                this.parseInt64(textChars, delimIdx + 1, textLength - delimIdx - 1, this.aInt64);
                double y = Double.longBitsToDouble(this.aInt64.getLongValue());
                this.aPoint.setValue(x, y);
                pointSerde.serialize((Object)this.aPoint, out);
                break;
            }
            case POINT3D: {
                int delimIdx = this.findDelim(textChars, nonTaggedTextOffset, nonTaggedTextLength, BuiltinType.APOINT3D);
                this.parseInt64(textChars, nonTaggedTextOffset, delimIdx - nonTaggedTextOffset, this.aInt64);
                double x = Double.longBitsToDouble(this.aInt64.getLongValue());
                int delimIdx2 = this.findDelim(textChars, delimIdx + 1, textLength - delimIdx - 1, BuiltinType.APOINT3D);
                this.parseInt64(textChars, delimIdx + 1, delimIdx2 - delimIdx - 1, this.aInt64);
                double y = Double.longBitsToDouble(this.aInt64.getLongValue());
                this.parseInt64(textChars, delimIdx2 + 1, textLength - delimIdx2 - 1, this.aInt64);
                double z = Double.longBitsToDouble(this.aInt64.getLongValue());
                this.aPoint3D.setValue(x, y, z);
                point3DSerde.serialize((Object)this.aPoint3D, out);
                break;
            }
            case CIRCLE: {
                int delimIdx = this.findDelim(textChars, nonTaggedTextOffset, nonTaggedTextLength, BuiltinType.ACIRCLE);
                this.parseInt64(textChars, nonTaggedTextOffset, delimIdx - nonTaggedTextOffset, this.aInt64);
                double x = Double.longBitsToDouble(this.aInt64.getLongValue());
                int delimIdx2 = this.findDelim(textChars, delimIdx + 1, textLength - delimIdx - 1, BuiltinType.ACIRCLE);
                this.parseInt64(textChars, delimIdx + 1, delimIdx2 - delimIdx - 1, this.aInt64);
                double y = Double.longBitsToDouble(this.aInt64.getLongValue());
                this.parseInt64(textChars, delimIdx2 + 1, textLength - delimIdx2 - 1, this.aInt64);
                double z = Double.longBitsToDouble(this.aInt64.getLongValue());
                this.aPoint.setValue(x, y);
                this.aCircle.setValue((APoint)this.aPoint, z);
                circleSerde.serialize((Object)this.aCircle, out);
                break;
            }
            case LINE: {
                int delimIdx = this.findDelim(textChars, nonTaggedTextOffset, nonTaggedTextLength, BuiltinType.ALINE);
                this.parseInt64(textChars, nonTaggedTextOffset, delimIdx - nonTaggedTextOffset, this.aInt64);
                double x = Double.longBitsToDouble(this.aInt64.getLongValue());
                int delimIdx2 = this.findDelim(textChars, delimIdx + 1, textLength - delimIdx - 1, BuiltinType.ALINE);
                this.parseInt64(textChars, delimIdx + 1, delimIdx2 - delimIdx - 1, this.aInt64);
                double y = Double.longBitsToDouble(this.aInt64.getLongValue());
                int delimIdx3 = this.findDelim(textChars, delimIdx2 + 1, textLength - delimIdx2 - 1, BuiltinType.ALINE);
                this.parseInt64(textChars, delimIdx2 + 1, delimIdx3 - delimIdx2 - 1, this.aInt64);
                double x2 = Double.longBitsToDouble(this.aInt64.getLongValue());
                this.parseInt64(textChars, delimIdx3 + 1, textLength - delimIdx3 - 1, this.aInt64);
                double y2 = Double.longBitsToDouble(this.aInt64.getLongValue());
                this.aPoint.setValue(x, y);
                this.aPoint2.setValue(x2, y2);
                this.aLine.setValue((APoint)this.aPoint, (APoint)this.aPoint2);
                lineSerde.serialize((Object)this.aLine, out);
                break;
            }
            case RECTANGLE: {
                int delimIdx = this.findDelim(textChars, nonTaggedTextOffset, nonTaggedTextLength, BuiltinType.ARECTANGLE);
                this.parseInt64(textChars, nonTaggedTextOffset, delimIdx - nonTaggedTextOffset, this.aInt64);
                double x = Double.longBitsToDouble(this.aInt64.getLongValue());
                int delimIdx2 = this.findDelim(textChars, delimIdx + 1, textLength - delimIdx - 1, BuiltinType.ARECTANGLE);
                this.parseInt64(textChars, delimIdx + 1, delimIdx2 - delimIdx - 1, this.aInt64);
                double y = Double.longBitsToDouble(this.aInt64.getLongValue());
                int delimIdx3 = this.findDelim(textChars, delimIdx2 + 1, textLength - delimIdx2 - 1, BuiltinType.ARECTANGLE);
                this.parseInt64(textChars, delimIdx2 + 1, delimIdx3 - delimIdx2 - 1, this.aInt64);
                double x2 = Double.longBitsToDouble(this.aInt64.getLongValue());
                this.parseInt64(textChars, delimIdx3 + 1, textLength - delimIdx3 - 1, this.aInt64);
                double y2 = Double.longBitsToDouble(this.aInt64.getLongValue());
                this.aPoint.setValue(x, y);
                this.aPoint2.setValue(x2, y2);
                this.aRectangle.setValue((APoint)this.aPoint, (APoint)this.aPoint2);
                rectangleSerde.serialize((Object)this.aRectangle, out);
                break;
            }
            case POLYGON: {
                int i;
                int delimIdx = this.findDelim(textChars, nonTaggedTextOffset, nonTaggedTextLength, BuiltinType.APOLYGON);
                this.parseInt64(textChars, nonTaggedTextOffset, delimIdx - nonTaggedTextOffset, this.aInt64);
                int numPoints = (int)this.aInt64.getLongValue();
                if (this.polygonPoints == null || this.polygonPoints.length != numPoints) {
                    this.polygonPoints = new AMutablePoint[numPoints];
                    for (i = 0; i < numPoints; ++i) {
                        this.polygonPoints[i] = new AMutablePoint(0.0, 0.0);
                    }
                }
                for (i = 0; i < numPoints; ++i) {
                    int delimIdx2 = this.findDelim(textChars, delimIdx + 1, textLength - delimIdx - 1, BuiltinType.APOLYGON);
                    this.parseInt64(textChars, delimIdx + 1, delimIdx2 - delimIdx - 1, this.aInt64);
                    double x = Double.longBitsToDouble(this.aInt64.getLongValue());
                    if (i < numPoints - 1) {
                        int delimIdx3 = this.findDelim(textChars, delimIdx2 + 1, textLength - delimIdx2 - 1, BuiltinType.APOLYGON);
                        this.parseInt64(textChars, delimIdx2 + 1, delimIdx3 - delimIdx2 - 1, this.aInt64);
                        delimIdx = delimIdx3;
                    } else {
                        this.parseInt64(textChars, delimIdx2 + 1, textLength - delimIdx2 - 1, this.aInt64);
                    }
                    double y = Double.longBitsToDouble(this.aInt64.getLongValue());
                    this.polygonPoints[i].setValue(x, y);
                }
                this.aPolygon.setValue((APoint[])this.polygonPoints);
                polygonSerde.serialize((Object)this.aPolygon, out);
                break;
            }
            default: {
                throw new RuntimeDataException(ErrorCode.TYPE_UNSUPPORTED, new Serializable[]{"", typeToUse.toString()});
            }
        }
    }

    private static ATypeTag parseTypeTag(char[] textChars, int textOffset, int textLength, AMutableInt32 outParsedLength) {
        byte typeTagByte;
        if (textLength == 0) {
            outParsedLength.setValue(0);
            return ATypeTag.STRING;
        }
        if (textChars[textOffset] == ':') {
            outParsedLength.setValue(1);
            return ATypeTag.STRING;
        }
        int typeTagLength = 2;
        if (textLength < typeTagLength) {
            return null;
        }
        try {
            typeTagByte = HexParser.getByteFromValidHexChars((char)textChars[textOffset], (char)textChars[textOffset + 1]);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(typeTagByte);
        if (typeTag == null) {
            return null;
        }
        if (typeTag == ATypeTag.MISSING || typeTag == ATypeTag.NULL) {
            outParsedLength.setValue(typeTagLength);
            return typeTag;
        }
        int delimiterLength = 1;
        if (textLength < typeTagLength + delimiterLength) {
            return null;
        }
        if (textChars[textOffset + typeTagLength] != ':') {
            return null;
        }
        outParsedLength.setValue(typeTagLength + delimiterLength);
        return typeTag;
    }

    private int findDelim(char[] text, int offset, int len, BuiltinType type) throws ParseException {
        try {
            return this.indexOf(text, offset, len, ':');
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(ErrorCode.PARSER_ADM_DATA_PARSER_WRONG_INSTANCE, new Serializable[]{new String(text, offset, len), type.getTypeName()});
        }
    }
}

