/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.HashSet;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class ComplexJoinInferenceRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (!(op instanceof AbstractScanOperator)) {
            return false;
        }
        Mutable opRef2 = (Mutable)op.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return false;
        }
        SubplanOperator subplan = (SubplanOperator)op2;
        Mutable opRef3 = (Mutable)subplan.getInputs().get(0);
        AbstractLogicalOperator op3 = (AbstractLogicalOperator)opRef3.getValue();
        if (op3.getOperatorTag() == LogicalOperatorTag.EMPTYTUPLESOURCE || op3.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return false;
        }
        if (ComplexJoinInferenceRule.subplanHasFreeVariables(subplan)) {
            return false;
        }
        HashSet varsUsedInUnnest = new HashSet();
        VariableUtilities.getUsedVariables((ILogicalOperator)op, varsUsedInUnnest);
        HashSet producedInSubplan = new HashSet();
        VariableUtilities.getProducedVariables((ILogicalOperator)subplan, producedInSubplan);
        if (!producedInSubplan.containsAll(varsUsedInUnnest)) {
            return false;
        }
        ComplexJoinInferenceRule.ntsToEtsInSubplan(subplan, context);
        ComplexJoinInferenceRule.cleanupJoins(subplan);
        InnerJoinOperator join = new InnerJoinOperator((Mutable)new MutableObject((Object)ConstantExpression.TRUE));
        join.setSourceLocation(op.getSourceLocation());
        join.getInputs().add(opRef3);
        opRef2.setValue((Object)OperatorManipulationUtil.eliminateSingleSubplanOverEts((SubplanOperator)subplan));
        join.getInputs().add(new MutableObject((Object)op));
        opRef.setValue((Object)join);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)join);
        return true;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    private static void cleanupJoins(SubplanOperator s) {
        for (ILogicalPlan p : s.getNestedPlans()) {
            for (Mutable r : p.getRoots()) {
                ComplexJoinInferenceRule.cleanupJoins((Mutable<ILogicalOperator>)r);
            }
        }
    }

    private static void cleanupJoins(Mutable<ILogicalOperator> opRef) {
        if (opRef.getValue() instanceof AbstractBinaryJoinOperator) {
            for (Mutable inputRef : ((ILogicalOperator)opRef.getValue()).getInputs()) {
                if (((ILogicalOperator)inputRef.getValue()).getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) continue;
                ((ILogicalOperator)opRef.getValue()).getInputs().remove(inputRef);
                opRef.setValue((Object)((ILogicalOperator)((Mutable)((ILogicalOperator)opRef.getValue()).getInputs().get(0)).getValue()));
                break;
            }
        }
        for (Mutable inputRef : ((ILogicalOperator)opRef.getValue()).getInputs()) {
            ComplexJoinInferenceRule.cleanupJoins((Mutable<ILogicalOperator>)inputRef);
        }
    }

    private static void ntsToEtsInSubplan(SubplanOperator s, IOptimizationContext context) throws AlgebricksException {
        for (ILogicalPlan p : s.getNestedPlans()) {
            for (Mutable r : p.getRoots()) {
                OperatorManipulationUtil.ntsToEts((Mutable)r, (IOptimizationContext)context);
            }
        }
    }

    private static boolean subplanHasFreeVariables(SubplanOperator s) throws AlgebricksException {
        for (ILogicalPlan p : s.getNestedPlans()) {
            for (Mutable r : p.getRoots()) {
                if (!OperatorPropertiesUtil.hasFreeVariablesInSelfOrDesc((AbstractLogicalOperator)((AbstractLogicalOperator)r.getValue()))) continue;
                return true;
            }
        }
        return false;
    }
}

