/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.impls;

import java.io.Serializable;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.common.buffercache.HaltOnFailureCallback;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public abstract class AbstractTreeIndex
implements ITreeIndex {
    public static final int MINIMAL_TREE_PAGE_COUNT = 2;
    public static final int MINIMAL_TREE_PAGE_COUNT_WITH_FILTER = 3;
    protected int rootPage = 1;
    protected final IBufferCache bufferCache;
    protected final IPageManager freePageManager;
    protected final ITreeIndexFrameFactory interiorFrameFactory;
    protected final ITreeIndexFrameFactory leafFrameFactory;
    protected final IBinaryComparatorFactory[] cmpFactories;
    protected final int fieldCount;
    protected FileReference file;
    private int fileId = -1;
    protected boolean isActive = false;
    protected int bulkloadLeafStart = 0;

    public AbstractTreeIndex(IBufferCache bufferCache, IPageManager freePageManager, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory leafFrameFactory, IBinaryComparatorFactory[] cmpFactories, int fieldCount, FileReference file) {
        this.bufferCache = bufferCache;
        this.freePageManager = freePageManager;
        this.interiorFrameFactory = interiorFrameFactory;
        this.leafFrameFactory = leafFrameFactory;
        this.cmpFactories = cmpFactories;
        this.fieldCount = fieldCount;
        this.file = file;
    }

    public synchronized void create() throws HyracksDataException {
        if (this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_CREATE_ACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        this.fileId = this.bufferCache.createFile(this.file);
        boolean failed = true;
        try {
            this.bufferCache.openFile(this.fileId);
            failed = false;
        }
        finally {
            if (failed) {
                this.bufferCache.deleteFile(this.fileId);
            }
        }
        failed = true;
        try {
            this.freePageManager.open(this.fileId);
            this.freePageManager.init(this.interiorFrameFactory, this.leafFrameFactory);
            this.setRootPage();
            this.freePageManager.close((IPageWriteFailureCallback)HaltOnFailureCallback.INSTANCE);
            failed = false;
        }
        finally {
            this.bufferCache.closeFile(this.fileId);
            if (failed) {
                this.bufferCache.deleteFile(this.fileId);
            }
        }
    }

    private void setRootPage() throws HyracksDataException {
        this.rootPage = this.freePageManager.getRootPageId();
        this.bulkloadLeafStart = this.freePageManager.getBulkLoadLeaf();
    }

    public synchronized void activate() throws HyracksDataException {
        if (this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_ACTIVATE_ACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        if (this.fileId >= 0) {
            this.bufferCache.openFile(this.fileId);
        } else {
            this.fileId = this.bufferCache.openFile(this.file);
        }
        this.freePageManager.open(this.fileId);
        this.setRootPage();
        this.isActive = true;
    }

    public synchronized void deactivate() throws HyracksDataException {
        if (!this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_DEACTIVATE_INACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        this.freePageManager.close((IPageWriteFailureCallback)HaltOnFailureCallback.INSTANCE);
        this.bufferCache.closeFile(this.fileId);
        this.isActive = false;
    }

    public void purge() throws HyracksDataException {
        if (this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_PURGE_ACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        this.bufferCache.purgeHandle(this.fileId);
        this.fileId = -1;
    }

    public synchronized void destroy() throws HyracksDataException {
        if (this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_DESTROY_ACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        this.bufferCache.deleteFile(this.file);
    }

    public synchronized void clear() throws HyracksDataException {
        if (!this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_CLEAR_INACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        this.freePageManager.init(this.interiorFrameFactory, this.leafFrameFactory);
        this.setRootPage();
    }

    public boolean isEmptyTree(ITreeIndexFrame frame) throws HyracksDataException {
        if (this.rootPage == -1) {
            return true;
        }
        return this.freePageManager.isEmpty(frame, this.rootPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getTreeHeight(ITreeIndexFrame frame) throws HyracksDataException {
        ICachedPage rootNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.rootPage), false);
        rootNode.acquireReadLatch();
        try {
            frame.setPage(rootNode);
            byte by = frame.getLevel();
            return by;
        }
        finally {
            rootNode.releaseReadLatch();
            this.bufferCache.unpin(rootNode);
        }
    }

    @Override
    public int getFileId() {
        return this.fileId;
    }

    public FileReference getFileReference() {
        return this.file;
    }

    public IBufferCache getBufferCache() {
        return this.bufferCache;
    }

    @Override
    public ITreeIndexFrameFactory getInteriorFrameFactory() {
        return this.interiorFrameFactory;
    }

    @Override
    public ITreeIndexFrameFactory getLeafFrameFactory() {
        return this.leafFrameFactory;
    }

    @Override
    public IBinaryComparatorFactory[] getComparatorFactories() {
        return this.cmpFactories;
    }

    @Override
    public IPageManager getPageManager() {
        return this.freePageManager;
    }

    @Override
    public int getRootPageId() {
        return this.rootPage;
    }

    @Override
    public int getFieldCount() {
        return this.fieldCount;
    }

    public IBinaryComparatorFactory[] getCmpFactories() {
        return this.cmpFactories;
    }

    public String toString() {
        return "{\"class\":\"" + this.getClass().getSimpleName() + "\",\"file\":\"" + this.file.getRelativePath() + "\"}";
    }
}

