/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin.recordgroup;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.asterix.fuzzyjoin.recordgroup.RecordGroup;
import org.apache.asterix.fuzzyjoin.similarity.SimilarityFilters;

public class RecordGroupLengthCount
extends RecordGroup {
    private final int min;
    private final int max;
    private final int[] lengthGroups;

    public RecordGroupLengthCount(int noGroups, SimilarityFilters fuzzyFilters, String lengthstatsPath) {
        super(noGroups, fuzzyFilters);
        int sum = 0;
        int range = 0;
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(lengthstatsPath));
            try {
                this.min = in.readInt();
                this.max = in.readInt();
                range = this.max - this.min + 1;
                this.lengthGroups = new int[range];
                try {
                    block8: while (true) {
                        int length = in.readInt();
                        int freq = in.readInt();
                        int lowAbs = fuzzyFilters.getLengthLowerBound(length);
                        int uppAbs = fuzzyFilters.getLengthUpperBound(length);
                        int low = Math.max(lowAbs - this.min, 0);
                        int upp = Math.min(uppAbs - this.min, this.max - this.min);
                        int l = low;
                        while (true) {
                            if (l > upp) continue block8;
                            int n = l++;
                            this.lengthGroups[n] = this.lengthGroups[n] + freq;
                            sum += freq;
                        }
                        break;
                    }
                }
                catch (EOFException length) {
                    in.close();
                }
            }
            catch (Throwable length) {
                try {
                    in.close();
                }
                catch (Throwable freq) {
                    length.addSuppressed(freq);
                }
                throw length;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        int countGroup = sum / noGroups;
        int count = 0;
        int group = 0;
        for (int i = 0; i < range; ++i) {
            this.lengthGroups[i] = group;
            if ((count += this.lengthGroups[i]) < countGroup || group >= noGroups - 1) continue;
            count = 0;
            ++group;
        }
    }

    @Override
    public Iterable<Integer> getGroups(Integer token, Integer length) {
        int lowAbs = this.fuzzyFilters.getLengthLowerBound(length);
        int uppAbs = this.fuzzyFilters.getLengthUpperBound(length);
        int low = Math.max(lowAbs - this.min, 0);
        int upp = Math.min(uppAbs - this.min, this.max - this.min);
        ArrayList<Integer> groups = new ArrayList<Integer>(upp - low + 1);
        int prevGroup = -1;
        for (int l = low; l <= upp; ++l) {
            int group = this.lengthGroups[l];
            if (group == prevGroup) continue;
            groups.add(group);
            prevGroup = group;
        }
        return groups;
    }

    @Override
    public boolean isLengthOnly() {
        return true;
    }
}

