/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.IVisitorExtension;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppAstVisitor;

public class BindingVariableVisitor
extends AbstractSqlppAstVisitor<Void, Collection<VariableExpr>> {
    @Override
    public Void visit(FromClause fromClause, Collection<VariableExpr> bindingVars) throws CompilationException {
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            fromTerm.accept(this, bindingVars);
        }
        return null;
    }

    @Override
    public Void visit(FromTerm fromTerm, Collection<VariableExpr> bindingVars) throws CompilationException {
        bindingVars.add(fromTerm.getLeftVariable());
        if (fromTerm.hasPositionalVariable()) {
            bindingVars.add(fromTerm.getPositionalVariable());
        }
        for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
            bindingVars.add(correlateClause.getRightVariable());
            if (!correlateClause.hasPositionalVariable()) continue;
            bindingVars.add(correlateClause.getPositionalVariable());
        }
        return null;
    }

    public Void visit(GroupbyClause groupbyClause, Collection<VariableExpr> bindingVars) throws CompilationException {
        HashSet<VariableExpr> gbyKeyVars = new HashSet<VariableExpr>();
        for (List gbyPairList : groupbyClause.getGbyPairList()) {
            for (GbyVariableExpressionPair gbyKey : gbyPairList) {
                VariableExpr var = gbyKey.getVar();
                if (var == null || !gbyKeyVars.add(var)) continue;
                bindingVars.add(var);
            }
        }
        if (groupbyClause.hasDecorList()) {
            for (GbyVariableExpressionPair gbyKey : groupbyClause.getDecorPairList()) {
                VariableExpr var = gbyKey.getVar();
                if (var == null) continue;
                bindingVars.add(var);
            }
        }
        if (groupbyClause.hasWithMap()) {
            bindingVars.addAll(groupbyClause.getWithVarMap().values());
        }
        bindingVars.add(groupbyClause.getGroupVar());
        return null;
    }

    public Void visit(QuantifiedExpression qe, Collection<VariableExpr> bindingVars) throws CompilationException {
        List quantifiedList = qe.getQuantifiedList();
        for (QuantifiedPair qp : quantifiedList) {
            bindingVars.add(qp.getVarExpr());
        }
        return null;
    }

    @Override
    public Void visit(IVisitorExtension ve, Collection<VariableExpr> arg) throws CompilationException {
        return ve.bindingVariableDispatch((ILangVisitor)this, arg);
    }
}

