/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.storage.blob.implementation.models.PageListHelper;
import com.azure.storage.blob.models.ClearRange;
import com.azure.storage.blob.models.PageListDeserializer;
import com.azure.storage.blob.models.PageRange;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;

@JacksonXmlRootElement(localName="PageList")
@JsonDeserialize(using=PageListDeserializer.class)
public final class PageList {
    @JsonProperty(value="PageRange")
    private List<PageRange> pageRange = new ArrayList<PageRange>();
    @JsonProperty(value="ClearRange")
    private List<ClearRange> clearRange = new ArrayList<ClearRange>();
    @JsonProperty(value="NextMarker")
    private String nextMarker;

    public List<PageRange> getPageRange() {
        return this.pageRange;
    }

    public PageList setPageRange(List<PageRange> pageRange) {
        this.pageRange = pageRange;
        return this;
    }

    public List<ClearRange> getClearRange() {
        return this.clearRange;
    }

    public PageList setClearRange(List<ClearRange> clearRange) {
        this.clearRange = clearRange;
        return this;
    }

    private String getNextMarker() {
        return this.nextMarker;
    }

    private PageList setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    static {
        PageListHelper.setAccessor(new PageListHelper.PageListAccessor(){

            @Override
            public String getNextMarker(PageList pageList) {
                return pageList.getNextMarker();
            }

            @Override
            public PageList setNextMarker(PageList pageList, String marker) {
                return pageList.setNextMarker(marker);
            }
        });
    }
}

