/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.evaluators;

import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.data.IBinaryBooleanInspector;
import org.apache.hyracks.algebricks.data.IBinaryBooleanInspectorFactory;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.EvaluatorContext;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparator;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class TuplePairEvaluatorFactory
implements ITuplePairComparatorFactory {
    private static final long serialVersionUID = 1L;
    private final IScalarEvaluatorFactory condition;
    private final IBinaryBooleanInspectorFactory booleanInspectorFactory;
    private final boolean tuplesAreReversed;

    public TuplePairEvaluatorFactory(IScalarEvaluatorFactory condition, boolean tuplesAreReversed, IBinaryBooleanInspectorFactory booleanInspectorFactory) {
        this.condition = condition;
        this.booleanInspectorFactory = booleanInspectorFactory;
        this.tuplesAreReversed = tuplesAreReversed;
    }

    public ITuplePairComparator createTuplePairComparator(IHyracksTaskContext ctx) throws HyracksDataException {
        EvaluatorContext evalCtx = new EvaluatorContext(ctx);
        IBinaryBooleanInspector bbi = this.booleanInspectorFactory.createBinaryBooleanInspector(ctx);
        return new TuplePairEvaluator(evalCtx, this.condition, bbi, this.tuplesAreReversed);
    }

    private static class TuplePairEvaluator
    implements ITuplePairComparator {
        private final IScalarEvaluator conditionEvaluator;
        private final IPointable res;
        private final CompositeFrameTupleReference tuplePairRef;
        private final IBinaryBooleanInspector booleanInspector;
        private final Reseter reseter;

        TuplePairEvaluator(IEvaluatorContext ctx, IScalarEvaluatorFactory conditionFactory, IBinaryBooleanInspector booleanInspector, boolean tuplesAreReversed) throws HyracksDataException {
            this.conditionEvaluator = conditionFactory.createScalarEvaluator(ctx);
            this.booleanInspector = booleanInspector;
            this.res = VoidPointable.FACTORY.createPointable();
            this.tuplePairRef = new CompositeFrameTupleReference(new FrameTupleReference(), new FrameTupleReference());
            this.reseter = tuplesAreReversed ? TuplePairEvaluator::reverseReset : TuplePairEvaluator::reset;
        }

        public int compare(IFrameTupleAccessor leftAccessor, int leftIndex, IFrameTupleAccessor rightAccessor, int rightIndex) throws HyracksDataException {
            this.reseter.reset(this.tuplePairRef, leftAccessor, leftIndex, rightAccessor, rightIndex);
            this.conditionEvaluator.evaluate(this.tuplePairRef, this.res);
            return this.booleanInspector.getBooleanValue(this.res.getByteArray(), this.res.getStartOffset(), this.res.getLength()) ? 0 : 1;
        }

        private static void reset(CompositeFrameTupleReference ref, IFrameTupleAccessor leftAccessor, int leftTupleIndex, IFrameTupleAccessor rightAccessor, int rightTupleIndex) {
            ref.reset(leftAccessor, leftTupleIndex, rightAccessor, rightTupleIndex);
        }

        private static void reverseReset(CompositeFrameTupleReference ref, IFrameTupleAccessor leftAccessor, int leftIndex, IFrameTupleAccessor rightAccessor, int rightIndex) {
            ref.reset(rightAccessor, rightIndex, leftAccessor, leftIndex);
        }
    }

    private static class CompositeFrameTupleReference
    implements IFrameTupleReference {
        private final FrameTupleReference refLeft;
        private final FrameTupleReference refRight;

        CompositeFrameTupleReference(FrameTupleReference refLeft, FrameTupleReference refRight) {
            this.refLeft = refLeft;
            this.refRight = refRight;
        }

        private void reset(IFrameTupleAccessor leftAccessor, int leftIndex, IFrameTupleAccessor rightAccessor, int rightIndex) {
            this.refLeft.reset(leftAccessor, leftIndex);
            this.refRight.reset(rightAccessor, rightIndex);
        }

        public int getFieldCount() {
            return this.refLeft.getFieldCount() + this.refRight.getFieldCount();
        }

        public byte[] getFieldData(int fIdx) {
            int leftFieldCount = this.refLeft.getFieldCount();
            return fIdx < leftFieldCount ? this.refLeft.getFieldData(fIdx) : this.refRight.getFieldData(fIdx - leftFieldCount);
        }

        public int getFieldStart(int fIdx) {
            int leftFieldCount = this.refLeft.getFieldCount();
            return fIdx < leftFieldCount ? this.refLeft.getFieldStart(fIdx) : this.refRight.getFieldStart(fIdx - leftFieldCount);
        }

        public int getFieldLength(int fIdx) {
            int leftFieldCount = this.refLeft.getFieldCount();
            return fIdx < leftFieldCount ? this.refLeft.getFieldLength(fIdx) : this.refRight.getFieldLength(fIdx - leftFieldCount);
        }

        public IFrameTupleAccessor getFrameTupleAccessor() {
            throw new NotImplementedException();
        }

        public int getTupleIndex() {
            throw new NotImplementedException();
        }
    }

    @FunctionalInterface
    private static interface Reseter {
        public void reset(CompositeFrameTupleReference var1, IFrameTupleAccessor var2, int var3, IFrameTupleAccessor var4, int var5);
    }
}

