/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.asterix.app.function.FunctionReader;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.input.record.CharArrayRecord;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACollection;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.util.ByteBufferInputStream;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.util.JSONUtil;

public class DumpIndexReader
extends FunctionReader {
    private final CharArrayRecord record;
    private final IIndexCursor searchCursor;
    private final RecordDescriptor secondaryRecDesc;
    private final StringBuilder recordBuilder = new StringBuilder();
    private final ByteBufferInputStream bbis = new ByteBufferInputStream();
    private final DataInputStream dis = new DataInputStream((InputStream)this.bbis);
    private final IIndexDataflowHelper indexDataflowHelper;
    private final IIndexAccessor accessor;

    public DumpIndexReader(IIndexDataflowHelper indexDataflowHelper, RecordDescriptor secondaryRecDesc, IBinaryComparatorFactory[] comparatorFactories) throws HyracksDataException {
        this.indexDataflowHelper = indexDataflowHelper;
        this.secondaryRecDesc = secondaryRecDesc;
        indexDataflowHelper.open();
        IIndex indexInstance = indexDataflowHelper.getIndexInstance();
        this.accessor = indexInstance.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        this.searchCursor = this.accessor.createSearchCursor(false);
        MultiComparator searchMultiComparator = MultiComparator.create((IBinaryComparatorFactory[])comparatorFactories);
        RangePredicate rangePredicate = new RangePredicate(null, null, true, true, searchMultiComparator, searchMultiComparator, null, null);
        this.accessor.search(this.searchCursor, (ISearchPredicate)rangePredicate);
        this.record = new CharArrayRecord();
    }

    public boolean hasNext() throws Exception {
        return this.searchCursor.hasNext();
    }

    public IRawRecord<char[]> next() throws IOException, InterruptedException {
        this.searchCursor.next();
        ITupleReference tuple = this.searchCursor.getTuple();
        this.buildJsonRecord(tuple);
        this.record.reset();
        this.record.append(this.recordBuilder.toString().toCharArray());
        this.record.endRecord();
        return this.record;
    }

    @Override
    public void close() throws IOException {
        this.bbis.close();
        this.dis.close();
        if (this.searchCursor != null) {
            this.searchCursor.close();
            this.searchCursor.destroy();
        }
        if (this.accessor != null) {
            this.accessor.destroy();
        }
        this.indexDataflowHelper.close();
    }

    private void buildJsonRecord(ITupleReference tuple) throws HyracksDataException {
        this.recordBuilder.setLength(0);
        this.recordBuilder.append("{\"values\":[");
        for (int j = 0; j < tuple.getFieldCount(); ++j) {
            this.bbis.setByteBuffer(ByteBuffer.wrap(tuple.getFieldData(j)), tuple.getFieldStart(j));
            IAObject field = (IAObject)this.secondaryRecDesc.getFields()[j].deserialize((DataInput)this.dis);
            ATypeTag tag = field.getType().getTypeTag();
            if (tag == ATypeTag.MISSING) continue;
            this.printField(this.recordBuilder, field);
            this.recordBuilder.append(",");
        }
        this.recordBuilder.deleteCharAt(this.recordBuilder.length() - 1);
        this.recordBuilder.append("]}");
    }

    private void printField(StringBuilder sb, IAObject field) {
        ATypeTag typeTag = field.getType().getTypeTag();
        switch (typeTag) {
            case OBJECT: {
                this.printObject(sb, (ARecord)field);
                break;
            }
            case ARRAY: 
            case MULTISET: {
                this.printCollection(sb, (IACollection)field);
                break;
            }
            case DATE: 
            case TIME: 
            case DATETIME: {
                JSONUtil.quoteAndEscape((StringBuilder)this.recordBuilder, (String)field.toString());
                break;
            }
            case STRING: {
                JSONUtil.quoteAndEscape((StringBuilder)this.recordBuilder, (String)((AString)field).getStringValue());
                break;
            }
            case MISSING: {
                break;
            }
            default: {
                sb.append(field);
            }
        }
    }

    private void printObject(StringBuilder sb, ARecord record) {
        sb.append("{ ");
        int num = record.numberOfFields();
        ARecordType type = record.getType();
        for (int i = 0; i < num; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IAObject value = record.getValueByPos(i);
            JSONUtil.quoteAndEscape((StringBuilder)sb, (String)type.getFieldNames()[i]);
            sb.append(": ");
            this.printField(sb, value);
        }
        sb.append(" }");
    }

    private void printCollection(StringBuilder sb, IACollection collection) {
        IACursor cursor = collection.getCursor();
        sb.append("[ ");
        boolean first = true;
        while (cursor.next()) {
            IAObject element = cursor.get();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            this.printField(sb, element);
        }
        sb.append(" ]");
    }
}

