/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc.core;

public class ADBProductVersion {
    public static final String ASTERIXDB = "Apache AsterixDB";
    private final String productName;
    private final String productVersion;
    private final int majorVersion;
    private final int minorVersion;

    public ADBProductVersion(String productName, String productVersion, int majorVersion, int minorVersion) {
        this.productName = productName != null ? productName : ASTERIXDB;
        this.productVersion = productVersion != null ? productVersion : majorVersion + "." + minorVersion;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public boolean isAtLeast(ADBProductVersion otherVersion) {
        return this.majorVersion == otherVersion.majorVersion ? this.minorVersion >= otherVersion.minorVersion : this.majorVersion > otherVersion.majorVersion;
    }

    public String toString() {
        return this.productName + '/' + this.productVersion;
    }
}

