/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.runtime.description.marshal.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.runtime.description.marshal.AnnotationDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.AnnotationBuilder;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.ArtifactProcessor;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.MarshalServiceRuntimeDescriptionImpl;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.PackageSetBuilder;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.PropertyDescriptorMapBuilder;
import org.apache.axis2.jaxws.utility.PropertyDescriptorPlus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MarshalServiceRuntimeDescriptionBuilder {
    private static Log log = LogFactory.getLog(MarshalServiceRuntimeDescriptionBuilder.class);

    private MarshalServiceRuntimeDescriptionBuilder() {
    }

    public static MarshalServiceRuntimeDescription create(ServiceDescription serviceDesc) {
        MarshalServiceRuntimeDescriptionImpl desc = new MarshalServiceRuntimeDescriptionImpl(MarshalServiceRuntimeDescriptionBuilder.getKey(), serviceDesc);
        MarshalServiceRuntimeDescriptionBuilder.init(desc, serviceDesc);
        return desc;
    }

    public static String getKey() {
        return "JAXWS-MARSHAL";
    }

    private static void init(MarshalServiceRuntimeDescriptionImpl marshalDesc, ServiceDescription serviceDesc) {
        Map<Class, Map<String, PropertyDescriptorPlus>> cache;
        Map<String, AnnotationDesc> map;
        if (log.isDebugEnabled()) {
            log.debug((Object)"start init");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Discover the artifacts");
        }
        ArtifactProcessor artifactProcessor = new ArtifactProcessor(serviceDesc);
        try {
            artifactProcessor.build();
        }
        catch (Throwable t) {
            throw ExceptionFactory.makeWebServiceException((Throwable)t);
        }
        marshalDesc.setRequestWrapperMap(artifactProcessor.getRequestWrapperMap());
        marshalDesc.setResponseWrapperMap(artifactProcessor.getResponseWrapperMap());
        marshalDesc.setFaultBeanDescMap(artifactProcessor.getFaultBeanDescMap());
        marshalDesc.setMethodMap(artifactProcessor.getMethodMap());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Build the annotations map");
        }
        try {
            map = AnnotationBuilder.getAnnotationDescs(serviceDesc, artifactProcessor);
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception occurred during cache processing.  This will impact performance:" + String.valueOf(t)));
            }
            map = new HashMap<String, AnnotationDesc>();
        }
        marshalDesc.setAnnotationMap(map);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Build the property descriptor cache");
        }
        try {
            cache = PropertyDescriptorMapBuilder.getPropertyDescMaps(serviceDesc, artifactProcessor);
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception occurred during cache processing.  This will impact performance:" + String.valueOf(t)));
            }
            cache = new HashMap<Class, Map<String, PropertyDescriptorPlus>>();
        }
        marshalDesc.setPropertyDescriptorMapCache(cache);
        TreeSet<String> packages = new TreeSet<String>();
        boolean doSchemaWalk = true;
        boolean doAnnotationWalk = true;
        packages = new TreeSet();
        if (doSchemaWalk) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Get the packages using the schema");
            }
            packages.addAll(PackageSetBuilder.getPackagesFromSchema(serviceDesc));
        }
        if (doAnnotationWalk) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Get the packages using the class annotations");
            }
            packages.addAll(PackageSetBuilder.getPackagesFromAnnotations(serviceDesc, (MarshalServiceRuntimeDescription)marshalDesc));
        }
        marshalDesc.setPackages(packages);
        if (log.isDebugEnabled()) {
            log.debug((Object)("MarshalDesc = " + String.valueOf(marshalDesc)));
            log.debug((Object)"end init");
        }
    }
}

