/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import jakarta.jws.WebParam;
import jakarta.jws.soap.SOAPBinding;
import jakarta.xml.ws.Holder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.axis2.jaxws.description.AttachmentDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ParameterDescription;
import org.apache.axis2.jaxws.description.ParameterDescriptionJava;
import org.apache.axis2.jaxws.description.ParameterDescriptionWSDL;
import org.apache.axis2.jaxws.description.builder.ParameterDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.converter.ConverterUtils;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.impl.OperationDescriptionImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ParameterDescriptionImpl
implements ParameterDescription,
ParameterDescriptionJava,
ParameterDescriptionWSDL {
    private static final Log log = LogFactory.getLog(ParameterDescriptionImpl.class);
    private OperationDescription parentOperationDescription;
    private Class parameterType;
    private Class parameterHolderActualType;
    private int parameterNumber = -1;
    private ParameterDescriptionComposite paramDescComposite;
    private WebParam webParamAnnotation;
    private String webParamName;
    private String webParamPartName;
    public static final String WebParam_TargetNamespace_DEFAULT = "";
    private String webParamTargetNamespace;
    private WebParam.Mode webParamMode;
    public static final Boolean WebParam_Header_DEFAULT = new Boolean(false);
    private Boolean webParamHeader;
    private boolean _setAttachmentDesc = false;
    private AttachmentDescription attachmentDesc = null;
    private boolean isListType = false;

    ParameterDescriptionImpl(int parameterNumber, Class parameterType, Type parameterGenericType, Annotation[] parameterAnnotations, OperationDescription parent) {
        this.parameterNumber = parameterNumber;
        this.parentOperationDescription = parent;
        this.parameterType = parameterType;
        if (ParameterizedType.class.isInstance(parameterGenericType)) {
            this.parameterHolderActualType = this.getGenericParameterActualType((ParameterizedType)parameterGenericType);
        }
        this.findWebParamAnnotation(parameterAnnotations);
        this.isListType = ConverterUtils.hasXmlListAnnotation(parameterAnnotations);
    }

    ParameterDescriptionImpl(int parameterNumber, ParameterDescriptionComposite pdc, OperationDescription parent) {
        this.paramDescComposite = pdc;
        this.parameterNumber = parameterNumber;
        this.parentOperationDescription = parent;
        this.webParamAnnotation = pdc.getWebParamAnnot();
        this.isListType = pdc.isListType();
    }

    private void findWebParamAnnotation(Annotation[] annotations) {
        for (Annotation checkAnnotation : annotations) {
            if (checkAnnotation.annotationType() != WebParam.class) continue;
            this.webParamAnnotation = (WebParam)checkAnnotation;
        }
    }

    @Override
    public OperationDescription getOperationDescription() {
        return this.parentOperationDescription;
    }

    @Override
    public Class getParameterType() {
        if (this.parameterType == null && this.paramDescComposite != null) {
            this.parameterType = this.paramDescComposite.getParameterTypeClass();
        }
        return this.parameterType;
    }

    @Override
    public Class getParameterActualType() {
        if (this.parameterHolderActualType == null && this.paramDescComposite != null && this.paramDescComposite.isHolderType()) {
            this.parameterHolderActualType = this.paramDescComposite.getHolderActualTypeClass();
            return this.parameterHolderActualType;
        }
        if (this.parameterHolderActualType != null) {
            return this.parameterHolderActualType;
        }
        if (this.paramDescComposite != null && this.parameterType == null) {
            this.parameterType = this.paramDescComposite.getParameterTypeClass();
        }
        return this.parameterType;
    }

    private Class getGenericParameterActualType(ParameterizedType parameterGenericType) {
        Class<?> returnClass = null;
        if (parameterGenericType != null && parameterGenericType.getRawType() == Holder.class) {
            Type type = parameterGenericType.getActualTypeArguments()[0];
            if (type != null && ParameterizedType.class.isInstance(type)) {
                returnClass = (Class)((ParameterizedType)type).getRawType();
            } else if (type != null && GenericArrayType.class.isInstance(type)) {
                Type componentType = ((GenericArrayType)type).getGenericComponentType();
                Class arrayClass = null;
                arrayClass = ParameterizedType.class.isInstance(componentType) ? (Class)((ParameterizedType)componentType).getRawType() : (Class)componentType;
                returnClass = Array.newInstance(arrayClass, 0).getClass();
            } else {
                returnClass = (Class<?>)type;
            }
        }
        return returnClass;
    }

    @Override
    public boolean isHolderType() {
        if (this.paramDescComposite != null) {
            return this.paramDescComposite.isHolderType();
        }
        return Holder.class.equals((Object)this.getParameterType());
    }

    @Override
    public WebParam getAnnoWebParam() {
        return this.webParamAnnotation;
    }

    @Override
    public String getParameterName() {
        return this.getAnnoWebParamName();
    }

    @Override
    public String getAnnoWebParamName() {
        if (this.webParamName == null) {
            this.webParamName = this.getAnnoWebParam() != null && !DescriptionUtils.isEmpty(this.getAnnoWebParam().name()) ? this.getAnnoWebParam().name() : (this.getOperationDescription().getSoapBindingStyle() == SOAPBinding.Style.DOCUMENT && this.getOperationDescription().getSoapBindingParameterStyle() == SOAPBinding.ParameterStyle.BARE ? this.getOperationDescription().getOperationName() : "arg" + this.parameterNumber);
        }
        return this.webParamName;
    }

    @Override
    public String getPartName() {
        return this.getAnnoWebParamPartName();
    }

    @Override
    public String getAnnoWebParamPartName() {
        if (this.webParamPartName == null) {
            this.webParamPartName = this.getAnnoWebParam() != null && !DescriptionUtils.isEmpty(this.getAnnoWebParam().partName()) ? this.getAnnoWebParam().partName() : this.getAnnoWebParamName();
        }
        return this.webParamPartName;
    }

    @Override
    public String getTargetNamespace() {
        return this.getAnnoWebParamTargetNamespace();
    }

    @Override
    public String getAnnoWebParamTargetNamespace() {
        if (this.webParamTargetNamespace == null) {
            this.webParamTargetNamespace = this.getAnnoWebParam() != null && !DescriptionUtils.isEmpty(this.getAnnoWebParam().targetNamespace()) ? this.getAnnoWebParam().targetNamespace() : (this.getOperationDescription().getSoapBindingStyle() == SOAPBinding.Style.DOCUMENT && this.getOperationDescription().getSoapBindingParameterStyle() == SOAPBinding.ParameterStyle.WRAPPED && !this.getAnnoWebParamHeader() ? WebParam_TargetNamespace_DEFAULT : ((EndpointDescriptionJava)((Object)this.getOperationDescription().getEndpointInterfaceDescription().getEndpointDescription())).getAnnoWebServiceTargetNamespace());
        }
        return this.webParamTargetNamespace;
    }

    @Override
    public WebParam.Mode getMode() {
        return this.getAnnoWebParamMode();
    }

    @Override
    public WebParam.Mode getAnnoWebParamMode() {
        if (this.webParamMode == null) {
            this.webParamMode = this.getAnnoWebParam() != null ? this.getAnnoWebParam().mode() : WebParam.Mode.IN;
            if (this.isHolderType() && this.webParamMode == WebParam.Mode.IN) {
                this.webParamMode = WebParam.Mode.INOUT;
            }
        }
        return this.webParamMode;
    }

    @Override
    public boolean isHeader() {
        return this.getAnnoWebParamHeader();
    }

    @Override
    public boolean getAnnoWebParamHeader() {
        if (this.webParamHeader == null) {
            this.webParamHeader = this.getAnnoWebParam() != null ? Boolean.valueOf(this.getAnnoWebParam().header()) : WebParam_Header_DEFAULT;
        }
        return this.webParamHeader;
    }

    public String toString() {
        String newline = "\n";
        String sameline = "; ";
        StringBuffer string = new StringBuffer();
        try {
            string.append(super.toString());
            string.append("\n");
            string.append("Name: " + this.getParameterName());
            string.append("\n");
            string.append("Namespace: " + this.getTargetNamespace());
            string.append("\n");
            string.append("PartName: " + this.getPartName());
            string.append("\n");
            string.append("Is header: " + this.isHeader());
            string.append("; ");
            string.append("Is holder: " + this.isHolderType());
            string.append("\n");
            string.append("Mode: " + String.valueOf(this.getMode()));
            string.append("\n");
            string.append("Type: " + String.valueOf(this.getParameterType()));
            string.append("; ");
            string.append("Actual type: " + String.valueOf(this.getParameterActualType()));
            if (this.getAttachmentDescription() != null) {
                string.append("\n");
                string.append(this.getAttachmentDescription().toString());
            }
        }
        catch (Throwable t) {
            string.append("\n");
            string.append("Complete debug information not currently available for ParameterDescription");
            return string.toString();
        }
        return string.toString();
    }

    @Override
    public boolean isListType() {
        return this.isListType;
    }

    private OperationDescriptionImpl getOperationDescriptionImpl() {
        if (this.getOperationDescription() instanceof OperationDescriptionImpl) {
            return (OperationDescriptionImpl)this.getOperationDescription();
        }
        return null;
    }

    @Override
    public AttachmentDescription getAttachmentDescription() {
        String partName = this.getPartName();
        if (partName != null && this.getOperationDescriptionImpl() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning parameter AttachmentDescription for partName: " + partName));
            }
            return this.getOperationDescriptionImpl().getPartAttachmentDescription(partName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Did not find parameter AttachmentDescription for partName: " + partName));
        }
        return null;
    }
}

